/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.amemailchecker.app.account.AccountBean;
import net.sf.amemailchecker.mail.cache.PostalAddresseeCacheAdapter;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Addressee;
import net.sf.amemailchecker.mail.model.PostalAddressee;

public enum PostalAddresseeCache {
    Instance;

    private List<PostalAddressee> personal = new ArrayList<PostalAddressee>();
    private Map<String, PostalAddressee> addressees = new HashMap<String, PostalAddressee>();
    private List<PostalAddresseeCacheAdapter> adapters = new ArrayList<PostalAddresseeCacheAdapter>();

    private PostalAddresseeCache() {
        this.addAdapter(new PostalAddresseeCacheAdapterImpl());
    }

    public void add(PostalAddressee postalAddressee) {
        this.addressees.put(postalAddressee.getAddress(), postalAddressee);
    }

    public void addAdapter(PostalAddresseeCacheAdapter postalAddresseeCacheAdapter) {
        this.adapters.add(postalAddresseeCacheAdapter);
    }

    public void removeAllAdapters() {
        this.adapters.clear();
    }

    public void clear() {
        this.addressees.clear();
    }

    public PostalAddressee findByAddress(String string) {
        for (PostalAddresseeCacheAdapter postalAddresseeCacheAdapter : this.adapters) {
            PostalAddressee postalAddressee = postalAddresseeCacheAdapter.findByAddress(string);
            if (postalAddressee == null) continue;
            return postalAddressee;
        }
        return null;
    }

    public void fill(PostalAddressee postalAddressee) {
        for (PostalAddresseeCacheAdapter postalAddresseeCacheAdapter : this.adapters) {
            postalAddresseeCacheAdapter.fill(postalAddressee);
        }
    }

    public void fill(List<PostalAddressee> list) {
        for (PostalAddresseeCacheAdapter postalAddresseeCacheAdapter : this.adapters) {
            postalAddresseeCacheAdapter.fill(list);
        }
    }

    public boolean isPersonal(PostalAddressee postalAddressee) {
        for (PostalAddresseeCacheAdapter postalAddresseeCacheAdapter : this.adapters) {
            if (!postalAddresseeCacheAdapter.isPersonal(postalAddressee)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(PostalAddressee postalAddressee) {
        for (PostalAddresseeCacheAdapter postalAddresseeCacheAdapter : this.adapters) {
            if (!postalAddresseeCacheAdapter.isRegistered(postalAddressee)) continue;
            return true;
        }
        return false;
    }

    public void updatePersonal(String string, Collection<Account> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Account account : collection) {
            arrayList.add(((AccountBean)account).getEmailAddress());
        }
        for (PostalAddresseeCacheAdapter postalAddresseeCacheAdapter : this.adapters) {
            postalAddresseeCacheAdapter.updatePersonal(string, arrayList);
        }
    }

    public synchronized void remove(String string) {
        this.addressees.remove(string);
    }

    private final class PostalAddresseeCacheAdapterImpl
    implements PostalAddresseeCacheAdapter {
        private PostalAddresseeCacheAdapterImpl() {
        }

        public boolean isRegistered(PostalAddressee postalAddressee) {
            return false;
        }

        public PostalAddressee findByAddress(String string) {
            PostalAddressee postalAddressee = (PostalAddressee)PostalAddresseeCache.this.addressees.get(string);
            if (postalAddressee == null) {
                for (PostalAddressee postalAddressee2 : PostalAddresseeCache.this.personal) {
                    if (!postalAddressee2.getAddress().equals(string)) continue;
                    postalAddressee = postalAddressee2;
                    break;
                }
            }
            return postalAddressee;
        }

        public void fill(PostalAddressee postalAddressee) {
        }

        public void fill(List<PostalAddressee> list) {
        }

        public boolean isPersonal(PostalAddressee postalAddressee) {
            for (PostalAddressee postalAddressee2 : PostalAddresseeCache.this.personal) {
                if (!postalAddressee2.getAddress().equals(postalAddressee.getAddress())) continue;
                return true;
            }
            return false;
        }

        public void updatePersonal(String string, List<String> list) {
            PostalAddresseeCache.this.personal.clear();
            for (String string2 : list) {
                PostalAddresseeCache.this.personal.add(new Addressee(string, string2));
            }
        }
    }
}

