/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.factory;

import java.util.Hashtable;
import java.util.Map;
import net.sf.amemailchecker.app.account.AccountBean;
import net.sf.amemailchecker.mail.IMailClient;
import net.sf.amemailchecker.mail.IMailIngoingClient;
import net.sf.amemailchecker.mail.IMailOutgoingClient;
import net.sf.amemailchecker.mail.Protocol;
import net.sf.amemailchecker.mail.impl.IMAPClient;
import net.sf.amemailchecker.mail.impl.IMAPProtocol;
import net.sf.amemailchecker.mail.impl.POP3Client;
import net.sf.amemailchecker.mail.impl.POP3Protocol;
import net.sf.amemailchecker.mail.impl.SMTPClient;
import net.sf.amemailchecker.mail.impl.SMTPProtocol;
import net.sf.amemailchecker.mail.model.Account;

public final class MailClientFactory {
    private static MailClientFactory instance;
    private Map<String, Map<Integer, IMailClient>> clients = new Hashtable<String, Map<Integer, IMailClient>>();

    private MailClientFactory() {
    }

    public static MailClientFactory getInstance() {
        if (instance == null) {
            instance = new MailClientFactory();
        }
        return instance;
    }

    public synchronized IMailClient getClient(Account account, Protocol protocol) {
        IMailClient iMailClient;
        Map<Integer, IMailClient> map = this.clients.get(account.getUuid());
        if (map == null) {
            map = new Hashtable<Integer, IMailClient>();
            this.clients.put(account.getUuid(), map);
        }
        if ((iMailClient = map.get(protocol.getId())) == null) {
            switch (protocol) {
                case IMAP: {
                    iMailClient = new IMAPClient(new IMAPProtocol());
                    break;
                }
                case POP3: {
                    iMailClient = new POP3Client(new POP3Protocol());
                    break;
                }
                case SMTP: {
                    iMailClient = new SMTPClient(new SMTPProtocol());
                }
            }
            map.put(protocol.getId(), iMailClient);
        }
        iMailClient.setAccountInfo((AccountBean)account);
        return iMailClient;
    }

    public IMailOutgoingClient getOutgoingClient(Account account) {
        return (IMailOutgoingClient)this.getClient(account, ((AccountBean)account).getOutgoingServer().getServerSettings().getProtocolType());
    }

    public IMailIngoingClient getIngoingClient(Account account) {
        return (IMailIngoingClient)this.getClient(account, ((AccountBean)account).getIngoingServer().getServerSettings().getProtocolType());
    }

    public IMailClient getClient(Account account, int n) {
        return this.getClient(account, Protocol.getById((int)n));
    }
}

