/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.factory;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.sf.amemailchecker.app.account.AccountBean;
import net.sf.amemailchecker.mail.IMailClient;
import net.sf.amemailchecker.mail.IMailIngoingClient;
import net.sf.amemailchecker.mail.IMailOutgoingClient;
import net.sf.amemailchecker.mail.IMailProtocol;
import net.sf.amemailchecker.mail.factory.ImplConfig;
import net.sf.amemailchecker.mail.factory.ImplConfigProtocol;

public final class XmlMailClientFactory {
    private static Logger logger = Logger.getLogger(XmlMailClientFactory.class.getName());
    private ImplConfig configuration;
    private Map<Integer, IMailClient> clients;
    private static XmlMailClientFactory instance;

    private XmlMailClientFactory() {
    }

    public static XmlMailClientFactory getInstance() {
        if (instance == null) {
            instance = new XmlMailClientFactory();
            instance.loadClients();
        }
        return instance;
    }

    private void loadClients() {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ImplConfig.class});
            Unmarshaller object = jAXBContext.createUnmarshaller();
            this.configuration = (ImplConfig)object.unmarshal(this.getClass().getResourceAsStream("resources/mail-impl-config.xml"));
        }
        catch (JAXBException jAXBException) {
            logger.severe("Cannot load mail classes");
            logger.log(Level.SEVERE, jAXBException.getMessage(), jAXBException);
            System.exit(0);
        }
        this.clients = new HashMap<Integer, IMailClient>();
        for (ImplConfigProtocol implConfigProtocol : this.configuration.getProtocolList()) {
            try {
                IMailClient iMailClient = (IMailClient)Class.forName(implConfigProtocol.getClientClassName()).newInstance();
                IMailProtocol iMailProtocol = (IMailProtocol)Class.forName(implConfigProtocol.getProtocolClassName()).newInstance();
                Method method = iMailClient.getClass().getMethod("setProtocol", IMailProtocol.class);
                method.invoke((Object)iMailClient, iMailProtocol);
                this.clients.put(implConfigProtocol.getId(), iMailClient);
            }
            catch (Exception exception) {
                logger.severe("Exception while construction of mail clients");
                logger.log(Level.SEVERE, exception.getMessage(), exception);
                System.exit(0);
            }
        }
    }

    public IMailClient getClient(AccountBean accountBean, int n) {
        IMailClient iMailClient = this.clients.get(n);
        iMailClient.setAccountInfo(accountBean);
        return iMailClient;
    }

    public IMailOutgoingClient getOutgoingClient(AccountBean accountBean) {
        return (IMailOutgoingClient)this.getClient(accountBean, accountBean.getOutgoingServer().getServerSettings().getProtocolType());
    }

    public IMailIngoingClient getIngoingClient(AccountBean accountBean) {
        return (IMailIngoingClient)this.getClient(accountBean, accountBean.getIngoingServer().getServerSettings().getProtocolType());
    }
}

