/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.sf.amemailchecker.app.account.AccountBean;
import net.sf.amemailchecker.app.account.AccountServerBean;
import net.sf.amemailchecker.mail.IMailProtocol;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.parser.MailMessageParser;
import net.sf.amemailchecker.mail.parser.MailMessageResolver;
import net.sf.amemailchecker.proxy.ProxyConnector;
import net.sf.amemailchecker.proxy.ProxyDispatcher;

abstract class BaseClient {
    private static Logger logger = Logger.getLogger(BaseClient.class.getName());
    protected MailMessageParser mailMessageParser = new MailMessageParser();
    protected MailMessageResolver mailMessageResolver = new MailMessageResolver();
    protected BufferedReader input;
    protected Writer output;
    protected Socket socket;
    protected IMailProtocol protocol;
    protected AccountBean account;

    BaseClient() {
    }

    abstract AccountServerBean getServerConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccountInfo(AccountBean accountBean) {
        BaseClient baseClient = this;
        synchronized (baseClient) {
            this.account = accountBean;
        }
    }

    public void setProtocol(IMailProtocol iMailProtocol) {
        this.protocol = iMailProtocol;
    }

    boolean signIn() throws IOException, ProtocolException {
        this.connect();
        this.checkForceTls();
        boolean bl = this.protocol.login(this.account.getUserCredentials().getUserName(), this.account.getUserCredentials().getPassword());
        if (!bl) {
            throw new ProtocolException(this.protocol.getUserResponse());
        }
        return bl;
    }

    void signOut() throws IOException {
        this.protocol.quit();
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection() throws IOException, ProtocolException {
        BaseClient baseClient = this;
        synchronized (baseClient) {
            this.signIn();
            this.signOut();
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public boolean connect() throws IOException {
        Proxy proxy = ProxyDispatcher.getDispatcher().getProxy();
        return proxy.type() == Proxy.Type.DIRECT ? this.connectDirect() : this.connectProxy(proxy);
    }

    public boolean connectDirect() throws UnknownHostException, IOException {
        this.socket = this.getServerConfiguration().isUseSSL() ? SSLSocketFactory.getDefault().createSocket(this.getServerConfiguration().getServerSettings().getHost(), this.getServerConfiguration().getPort()) : SocketFactory.getDefault().createSocket(this.getServerConfiguration().getServerSettings().getHost(), this.getServerConfiguration().getPort());
        return this.postConnect();
    }

    public boolean connectProxy(Proxy proxy) throws IOException {
        ProxyConnector proxyConnector = new ProxyConnector();
        this.socket = proxyConnector.establishProxyConnection((InetSocketAddress)proxy.address());
        String string = this.getServerConfiguration().getServerSettings().getHost();
        int n = this.getServerConfiguration().getPort();
        if (proxy.type().equals((Object)Proxy.Type.HTTP)) {
            this.socket = proxyConnector.connectHttp(this.socket, string, n);
        }
        if (proxy.type().equals((Object)Proxy.Type.SOCKS)) {
            this.socket = proxyConnector.connectSocks(this.socket, string, n);
        }
        if (this.getServerConfiguration().isUseSSL()) {
            return this.wrapSocket();
        }
        return this.postConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.output != null) {
                this.output.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            logger.severe("Failed to call disconnect() - already disconnected");
        }
        finally {
            this.socket = null;
            this.output = null;
            this.input = null;
        }
    }

    void checkForceTls() throws IOException, ProtocolException {
        if (this.getServerConfiguration().isUseStartTls()) {
            this.protocol.startTls();
            this.wrapSocket();
        }
    }

    boolean wrapSocket() throws IOException {
        logger.info("Starting establish SSL tunneling");
        SSLSocket sSLSocket = (SSLSocket)((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(this.socket, this.getServerConfiguration().getServerSettings().getHost(), this.getServerConfiguration().getPort(), true);
        sSLSocket.setUseClientMode(true);
        sSLSocket.setEnabledProtocols(sSLSocket.getEnabledProtocols());
        sSLSocket.setEnabledCipherSuites(sSLSocket.getEnabledCipherSuites());
        sSLSocket.setEnableSessionCreation(true);
        sSLSocket.startHandshake();
        this.socket = sSLSocket;
        logger.info("SSL tunnel has been established");
        return this.postConnect();
    }

    private void setUpProtocol() throws IOException {
        this.input = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.output = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "iso-8859-1")));
        this.protocol.setInput(this.input);
        this.protocol.setOutput(this.output);
    }

    private boolean postConnect() throws IOException {
        this.socket.setSoTimeout(15000);
        this.setUpProtocol();
        return this.socket.isConnected();
    }
}

