/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.amemailchecker.app.account.AccountServerBean;
import net.sf.amemailchecker.mail.IMailIngoingClient;
import net.sf.amemailchecker.mail.MessageFlag;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.impl.BaseClient;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;
import net.sf.amemailchecker.mail.model.MailBox;

abstract class BaseIngoingClient
extends BaseClient
implements IMailIngoingClient {
    private Map<Folder, List<String>> checkedUidList;

    BaseIngoingClient() {
    }

    @Override
    public void setCheckedUidList(Map<Folder, List<String>> map) {
        this.checkedUidList = map;
    }

    @Override
    public Map<Folder, List<String>> getCheckedUidList() {
        return this.checkedUidList;
    }

    @Override
    AccountServerBean getServerConfiguration() {
        return this.account.getIngoingServer();
    }

    abstract Map<Folder, List<Letter>> unread(MailBox var1, boolean var2) throws IOException, ProtocolException;

    abstract boolean flag(Folder var1, String var2, MessageFlag ... var3) throws IOException, ProtocolException;

    abstract Letter fetchMessage(Folder var1, Letter var2) throws IOException, ProtocolException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Folder, List<Letter>> checkUnread(MailBox mailBox, boolean bl) throws IOException, ProtocolException {
        BaseIngoingClient baseIngoingClient = this;
        synchronized (baseIngoingClient) {
            this.signIn();
            Map<Folder, List<Letter>> map = this.unread(mailBox, bl);
            this.signOut();
            return map;
        }
    }

    boolean isMessageChecked(Folder folder, String string) {
        if (this.checkedUidList == null) {
            return false;
        }
        List<String> list = this.checkedUidList.get(folder);
        if (list == null || list.size() <= 0) {
            return false;
        }
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.equalsIgnoreCase(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> markAsRead(Folder folder, List<Letter> list) throws IOException, ProtocolException {
        BaseIngoingClient baseIngoingClient = this;
        synchronized (baseIngoingClient) {
            return this.flag(folder, list, MessageFlag.Seen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> markDelete(Folder folder, List<Letter> list) throws IOException, ProtocolException {
        BaseIngoingClient baseIngoingClient = this;
        synchronized (baseIngoingClient) {
            return this.flag(folder, list, MessageFlag.Seen, MessageFlag.Deleted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Letter> fetch(Folder folder, List<Letter> list) throws IOException, ProtocolException {
        BaseIngoingClient baseIngoingClient = this;
        synchronized (baseIngoingClient) {
            this.signIn();
            for (Letter letter : list) {
                this.fetchMessage(folder, letter);
            }
            this.signOut();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> flag(Folder folder, List<Letter> list, MessageFlag ... messageFlagArray) throws IOException, ProtocolException {
        BaseIngoingClient baseIngoingClient = this;
        synchronized (baseIngoingClient) {
            this.signIn();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Letter letter : list) {
                if (!this.flag(folder, letter.getUid(), messageFlagArray)) continue;
                arrayList.add(letter.getUid());
                for (MessageFlag messageFlag : messageFlagArray) {
                    ((LetterImpl)letter).addFlag(messageFlag);
                }
            }
            this.signOut();
            return arrayList;
        }
    }
}

