/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.sf.amemailchecker.mail.exception.ExtensionNotSupportedException;
import net.sf.amemailchecker.mail.impl.extension.MailProtocolExtensionBean;

abstract class BaseMailProtocol {
    protected String userResponse;
    protected BufferedReader input;
    protected Writer output;
    protected MailProtocolExtensionBean extensionBean;

    BaseMailProtocol() {
    }

    public String getUserResponse() {
        return this.userResponse;
    }

    public void setUserResponse(String string) {
        this.userResponse = string;
    }

    public void setInput(BufferedReader bufferedReader) {
        this.input = bufferedReader;
    }

    public void setOutput(Writer writer) {
        this.output = writer;
    }

    protected void passCommand(String string) throws IOException {
        this.output.write(string + "\r\n");
        this.output.flush();
    }

    protected String commandSingleResult(String string) throws IOException {
        this.passCommand(string);
        String string2 = this.input.readLine();
        if (string2.equals("+")) {
            string2 = this.input.readLine();
        }
        return string2;
    }

    protected boolean commandSingleResult(String string, String string2) throws IOException {
        this.userResponse = this.commandSingleResult(string);
        return this.userResponse.startsWith(string2);
    }

    protected String getDomain() {
        InetAddress inetAddress;
        String string = "";
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
        string = inetAddress.getCanonicalHostName();
        if (string == null) {
            string = "[" + inetAddress.getHostAddress() + "]";
        }
        return string;
    }

    public boolean auth(String string, char[] cArray) throws IOException, ExtensionNotSupportedException {
        if (this.extensionBean == null) {
            throw new ExtensionNotSupportedException("Server doesn't support extensions!");
        }
        if (this.extensionBean.isAuthTypeSupported("PLAIN")) {
            return this.authPlain(string, cArray);
        }
        throw new ExtensionNotSupportedException("Server doesn't support any auth type known by client!");
    }

    public void quit() throws IOException {
        if (this.extensionBean != null) {
            this.extensionBean.clearExtensionList();
        }
    }

    protected abstract boolean authPlain(String var1, char[] var2) throws IOException;
}

