/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.gui.messageviewer.foldertree.FolderTreeModelHierarchyIterator;
import net.sf.amemailchecker.mail.MessageFlag;
import net.sf.amemailchecker.mail.exception.FolderNotFoundException;
import net.sf.amemailchecker.mail.exception.MessageNotFoundException;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.impl.BaseIngoingClient;
import net.sf.amemailchecker.mail.impl.IMAPFetchCommand;
import net.sf.amemailchecker.mail.impl.IMAPProtocol;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.impl.letter.RawMessagePart;
import net.sf.amemailchecker.mail.impl.mailbox.IMAPFolder;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;
import net.sf.amemailchecker.mail.model.MailBox;
import net.sf.amemailchecker.mail.parser.reader.IMAPReader;

public class IMAPClient
extends BaseIngoingClient {
    Logger logger = Logger.getLogger(IMAPClient.class.getName());

    public IMAPClient() {
    }

    public IMAPClient(IMAPProtocol iMAPProtocol) {
        this.protocol = iMAPProtocol;
    }

    @Override
    public boolean connect() throws IOException {
        String string;
        boolean bl = super.connect();
        if (bl && !((IMAPProtocol)this.protocol).isPositiveResponse(string = this.input.readLine())) {
            throw new IOException(string);
        }
        return bl;
    }

    @Override
    Map<Folder, List<Letter>> unread(MailBox mailBox, boolean bl) throws IOException, ProtocolException {
        HashMap<Folder, List<Letter>> hashMap = new HashMap<Folder, List<Letter>>();
        FolderTreeModelHierarchyIterator folderTreeModelHierarchyIterator = new FolderTreeModelHierarchyIterator(mailBox.getFolders());
        while (folderTreeModelHierarchyIterator.hasNext()) {
            Folder folder = (Folder)folderTreeModelHierarchyIterator.next();
            if (!folder.isEnabled() || !folder.isSelectable()) continue;
            try {
                hashMap.put(folder, this.unread(folder, bl));
            }
            catch (FolderNotFoundException folderNotFoundException) {
                this.logger.log(Level.INFO, "The folder " + folder.getName() + " wasn't found on the server");
            }
        }
        return hashMap;
    }

    List<Letter> unread(Folder folder, boolean bl) throws IOException, ProtocolException {
        Integer n;
        ArrayList<Letter> arrayList = new ArrayList<Letter>();
        try {
            n = ((IMAPProtocol)this.protocol).status(folder.getName());
        }
        catch (ProtocolException protocolException) {
            if (!protocolException.isNegative()) {
                throw protocolException;
            }
            throw new FolderNotFoundException(protocolException.getMessage());
        }
        if (n == 0) {
            return arrayList;
        }
        ((IMAPProtocol)this.protocol).select(folder.getName());
        List<Integer> list = ((IMAPProtocol)this.protocol).searchCommand.unseen();
        for (Integer n2 : list) {
            try {
                Long l = ((IMAPProtocol)this.protocol).fetchCommand.uid(n2);
                if (this.isMessageChecked(folder, l.toString())) continue;
                RawMessagePart rawMessagePart = new RawMessagePart();
                LetterImpl letterImpl = new LetterImpl(rawMessagePart);
                letterImpl.setUid(l.toString());
                this.fetchHeader(n2, "Message-ID", rawMessagePart);
                this.fetchHeader(n2, "From", rawMessagePart);
                this.fetchHeader(n2, "Date", rawMessagePart);
                this.fetchHeader(n2, "Subject", rawMessagePart);
                this.fetchHeader(n2, "CC", rawMessagePart);
                this.fetchHeader(n2, "To", rawMessagePart);
                this.fetchHeader(n2, "MIME-Version", rawMessagePart);
                if (letterImpl.isMimeMessage()) {
                    this.fetchHeader(n2, "Content-Type", rawMessagePart);
                }
                if (!letterImpl.isMimeMultipart()) {
                    this.fetchHeader(n2, "Content-Transfer-Encoding", rawMessagePart);
                }
                if (bl) {
                    this.fetchBody(n2, letterImpl);
                }
                if (letterImpl.getMessageID() == null) {
                    letterImpl.setMessageID(l.toString());
                }
                this.mailMessageParser.parseFromHeader(letterImpl);
                this.mailMessageParser.parseSubjectHeader(letterImpl);
                this.mailMessageParser.parseAddresseesHeader(letterImpl, "CC");
                this.mailMessageParser.parseAddresseesHeader(letterImpl, "To");
                this.mailMessageParser.parseDateHeader(letterImpl);
                arrayList.add(letterImpl);
                this.logger.info("[" + this.account.getTitle() + "] - " + "Reading finished for MsgNum [" + n2 + "]");
            }
            catch (ProtocolException protocolException) {
                this.logger.log(Level.SEVERE, protocolException.getMessage(), protocolException.getCause());
            }
            catch (Exception exception) {
                this.logger.log(Level.INFO, "Unable to process letter with message sequence number: " + n2);
                this.logger.log(Level.SEVERE, exception.getMessage(), exception.getCause());
            }
        }
        return arrayList;
    }

    private void fetchHeader(Integer n, String string, RawMessagePart rawMessagePart) throws IOException, ProtocolException {
        String string2;
        IMAPFetchCommand iMAPFetchCommand = ((IMAPProtocol)this.protocol).fetchCommand;
        iMAPFetchCommand.header(n, string);
        while ((string2 = iMAPFetchCommand.readResponseLine()) != null) {
            this.mailMessageResolver.resolveHeader(string2, string, rawMessagePart);
        }
    }

    private void fetchBody(Integer n, LetterImpl letterImpl) throws IOException, ProtocolException {
        IMAPFetchCommand iMAPFetchCommand = ((IMAPProtocol)this.protocol).fetchCommand;
        iMAPFetchCommand.peek(n, "TEXT");
        IMAPReader iMAPReader = new IMAPReader(((IMAPProtocol)this.protocol).input, iMAPFetchCommand.getCurrentCommandPrefix());
        this.mailMessageResolver.resolveRootPart(iMAPReader, letterImpl);
        this.logger.info("Fetch Body finished for MsgNum [" + n + "]");
        this.mailMessageParser.processBody(letterImpl.getRawMessage(), letterImpl);
    }

    @Override
    boolean flag(Folder folder, String string, MessageFlag ... messageFlagArray) throws IOException, ProtocolException {
        ((IMAPProtocol)this.protocol).select(folder.getName());
        boolean bl = ((IMAPProtocol)this.protocol).store(string, messageFlagArray);
        for (MessageFlag messageFlag : messageFlagArray) {
            this.logger.info("[" + this.account.getTitle() + "] - " + "Finished flagged [" + (Object)((Object)messageFlag) + "] for MsgUID [" + string + "]");
        }
        return bl;
    }

    @Override
    public Letter fetchMessage(Folder folder, Letter letter) throws IOException, ProtocolException {
        ((IMAPProtocol)this.protocol).select(folder.getName());
        List<Integer> list = ((IMAPProtocol)this.protocol).searchCommand.uid(letter.getUid());
        if (list.size() <= 0) {
            throw new MessageNotFoundException("Message with UID [" + letter.getUid() + "] wasn't found on the server");
        }
        this.fetchBody(list.get(0), (LetterImpl)letter);
        return letter;
    }

    @Override
    public synchronized List<Folder> listFolders() throws IOException, ProtocolException {
        this.signIn();
        List<Folder> list = ((IMAPProtocol)this.protocol).list();
        this.signOut();
        FolderTreeModelHierarchyIterator folderTreeModelHierarchyIterator = new FolderTreeModelHierarchyIterator(list);
        while (folderTreeModelHierarchyIterator.hasNext()) {
            IMAPFolder iMAPFolder = (IMAPFolder)folderTreeModelHierarchyIterator.next();
            iMAPFolder.setLabel(this.mailMessageParser.decodeFolderName(iMAPFolder.getLabel()));
        }
        return list;
    }

    @Override
    public synchronized void createFolder(Folder folder, Folder folder2, String string) throws IOException, ProtocolException {
        this.signIn();
        string = this.mailMessageParser.encodeFolderName(string);
        ((IMAPFolder)folder).setName(folder2 != null ? folder2.getName() + folder.getDelimiter() + string : string);
        ((IMAPProtocol)this.protocol).create(folder.getName());
        this.signOut();
    }

    @Override
    public synchronized void deleteFolder(Folder folder) throws IOException, ProtocolException {
        this.signIn();
        ((IMAPProtocol)this.protocol).delete(folder.getName());
        this.signOut();
    }

    @Override
    public synchronized String renameFolder(Folder folder, String string) throws IOException, ProtocolException {
        this.signIn();
        string = this.mailMessageParser.encodeFolderName(string);
        String string2 = folder.getName();
        string = string2.substring(0, string2.lastIndexOf(folder.getDelimiter()) + 1) + string;
        ((IMAPProtocol)this.protocol).rename(folder.getName(), string);
        this.signOut();
        return string;
    }

    @Override
    public synchronized List<Letter> copy(List<Letter> list, Folder folder, Folder folder2) throws IOException, ProtocolException {
        Object object;
        this.signIn();
        ((IMAPProtocol)this.protocol).examine(folder2.getName());
        for (Letter letter : list) {
            ((IMAPProtocol)this.protocol).select(folder.getName());
            object = ((IMAPProtocol)this.protocol).searchCommand.uid(letter.getUid());
            ((IMAPProtocol)this.protocol).copy(object.get(0), folder2.getName());
        }
        ArrayList arrayList = new ArrayList();
        ((IMAPProtocol)this.protocol).select(folder2.getName());
        int n = ((IMAPProtocol)this.protocol).statusCommand(folder2.getName(), IMAPProtocol.StatusCommandToken.MESSAGES).get((Object)IMAPProtocol.StatusCommandToken.MESSAGES);
        object = list.iterator();
        int n2 = n - list.size();
        while (n2 < n) {
            Long l = ((IMAPProtocol)this.protocol).fetchCommand.uid(++n2);
            LetterImpl letterImpl = new LetterImpl((LetterImpl)object.next(), true, true);
            letterImpl.setUid(l.toString());
            arrayList.add(letterImpl);
        }
        this.signOut();
        return arrayList;
    }
}

