/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.impl;

import java.io.IOException;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.impl.IMAPProtocol;

public class IMAPFetchCommand {
    private IMAPProtocol protocol;
    private String currentCommandPrefix;

    IMAPFetchCommand(IMAPProtocol iMAPProtocol) {
        this.protocol = iMAPProtocol;
    }

    public Long uid(Integer n) throws IOException, ProtocolException {
        return Long.valueOf(this.fetchSingle(n, "UID"));
    }

    private String fetchSingle(Integer n, String string) throws IOException, ProtocolException {
        this.currentCommandPrefix = this.protocol.tagCommandNum();
        String string2 = this.currentCommandPrefix + " FETCH " + n + " (" + string + ")";
        String string3 = this.protocol.commandSingleResult(string2);
        if (!string3.startsWith("* " + n)) {
            throw new ProtocolException("Cannot execute command for MsgNum [" + n + "]");
        }
        if (!this.commandFinished(this.protocol.input.readLine())) {
            throw new ProtocolException("Multiple response incorrectly handled for MsgNum [" + n + "]");
        }
        return string3.substring(string3.indexOf(string) + string.length(), string3.length() - 1).trim();
    }

    public void peek(Integer n, String string) throws IOException, ProtocolException {
        if (!this.command(n, "BODY.PEEK[" + string + "]")) {
            throw new ProtocolException("Cannot execute command for MsgNum [" + n + "]");
        }
    }

    public void header(Integer n, String string) throws IOException, ProtocolException {
        this.peek(n, "HEADER.FIELDS (" + string + ")");
    }

    private boolean command(Integer n, String string) throws IOException {
        String string2 = "* " + n;
        this.currentCommandPrefix = this.protocol.tagCommandNum();
        string = this.currentCommandPrefix + " FETCH " + n + " " + string;
        return this.protocol.commandSingleResult(string, string2);
    }

    public String readResponseLine() throws IOException {
        String string = this.protocol.input.readLine();
        return this.finishReading(string);
    }

    private String finishReading(String string) throws IOException {
        if (this.commandFinished(string)) {
            return null;
        }
        if (string.equals(")")) {
            string = this.protocol.input.readLine();
            if (this.commandFinished(string)) {
                return null;
            }
            return ")" + string;
        }
        return string;
    }

    private boolean commandFinished(String string) throws IOException {
        return string.startsWith(this.currentCommandPrefix);
    }

    public String getCurrentCommandPrefix() {
        return this.currentCommandPrefix;
    }
}

