/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.amemailchecker.mail.IMailIngoingProtocol;
import net.sf.amemailchecker.mail.MessageFlag;
import net.sf.amemailchecker.mail.exception.AuthenticationException;
import net.sf.amemailchecker.mail.exception.ExtensionNotSupportedException;
import net.sf.amemailchecker.mail.exception.FolderNotFoundException;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.impl.BaseMailProtocol;
import net.sf.amemailchecker.mail.impl.IMAPFetchCommand;
import net.sf.amemailchecker.mail.impl.IMAPSearchCommand;
import net.sf.amemailchecker.mail.impl.extension.IMAPExtensionBean;
import net.sf.amemailchecker.mail.impl.mailbox.IMAPFolder;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.parser.CodecUtil;
import net.sf.amemailchecker.util.StringUtil;

public class IMAPProtocol
extends BaseMailProtocol
implements IMailIngoingProtocol {
    public static final String IMAP_RESPONSE_CODE_OK = "ok";
    public static final String IMAP_RESPONSE_CODE_ERR = "bad";
    public static final String IMAP_RESPONSE_CODE_NO = "no";
    private int cmdNumIncrement = 0;
    IMAPFetchCommand fetchCommand = new IMAPFetchCommand(this);
    IMAPSearchCommand searchCommand = new IMAPSearchCommand(this);

    protected String tagCommandNum() {
        return "a" + ++this.cmdNumIncrement;
    }

    @Override
    public boolean login(String string, char[] cArray) throws IOException, ProtocolException {
        try {
            this.capability();
            return this.auth(string, cArray);
        }
        catch (ExtensionNotSupportedException extensionNotSupportedException) {
            boolean bl = this.loginSimple(string, cArray);
            if (!bl) {
                if (this.isNegativeResponse(this.userResponse)) {
                    throw new AuthenticationException(this.userResponse);
                }
                if (this.isBadResponse(this.userResponse)) {
                    throw new ProtocolException(this.userResponse);
                }
            }
            return bl;
        }
    }

    @Override
    public void startTls() throws IOException, ProtocolException {
        try {
            this.capability();
        }
        catch (ExtensionNotSupportedException extensionNotSupportedException) {
            throw new ProtocolException("Cannot start TLS negotiation\nSTARTTLS is not supported by the server");
        }
        if (!this.extensionBean.isExtensionSupported("STARTTLS")) {
            throw new ProtocolException("Cannot start TLS negotiation\nSTARTTLS is not supported by the server");
        }
        String string = this.tagCommandNum();
        String string2 = this.commandSingleResult(string + " STARTTLS");
        if (this.isNegativeResponse(string2) || this.isBadResponse(string2)) {
            throw new ProtocolException("Cannot start TLS negotiation");
        }
    }

    public boolean loginSimple(String string, char[] cArray) throws IOException, ProtocolException {
        return this.executeCommand("LOGIN " + string + " " + new String(cArray));
    }

    @Override
    protected boolean authPlain(String string, char[] cArray) throws IOException {
        String string2 = "\u0000" + string + "\u0000" + String.valueOf(cArray);
        String string3 = this.tagCommandNum();
        try {
            string2 = CodecUtil.encodeBase64(string2);
            this.passCommand(string3 + " AUTHENTICATE PLAIN");
            return this.executeCommand(string2, string3);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public void capability() throws IOException, ExtensionNotSupportedException {
        String string = this.tagCommandNum();
        String string2 = this.commandSingleResult(string + " CAPABILITY");
        if (this.isNegativeResponse(string2)) {
            throw new ExtensionNotSupportedException("Extension does not supported");
        }
        this.extensionBean = new IMAPExtensionBean();
        this.extensionBean.addExtension(string2.substring(13, string2.length()).trim());
        while ((string2 = this.input.readLine()) != null && !string2.startsWith(string + " OK")) {
            this.extensionBean.addExtension(string2.substring(13, string2.length()).trim());
        }
    }

    @Override
    public void quit() throws IOException {
        super.quit();
        String string = this.tagCommandNum();
        this.commandSingleResult(string + " LOGOUT");
    }

    public Map<StatusCommandToken, Integer> statusCommand(String string, StatusCommandToken ... statusCommandTokenArray) throws IOException, ProtocolException {
        String string2 = this.tagCommandNum();
        String string3 = string2 + " STATUS \"" + string + "\" (";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < statusCommandTokenArray.length; ++i) {
            stringBuilder.append(statusCommandTokenArray[i].name());
            if (i >= statusCommandTokenArray.length - 1) continue;
            stringBuilder.append(" ");
        }
        stringBuilder.append(")");
        this.passCommand(string3 + stringBuilder.toString());
        HashMap<StatusCommandToken, Integer> hashMap = new HashMap<StatusCommandToken, Integer>();
        while ((this.userResponse = this.input.readLine()) != null) {
            if (this.userResponse.startsWith(string2)) {
                if (this.isPositiveResponse(this.userResponse, string2)) break;
                throw new ProtocolException(this.userResponse, this.isNegativeResponse(this.userResponse, string2));
            }
            this.userResponse = this.userResponse.substring(this.userResponse.indexOf(40) + 1, this.userResponse.length() - 1);
            String[] stringArray = this.userResponse.split(" ");
            for (int i = 0; i < stringArray.length; i += 2) {
                hashMap.put(StatusCommandToken.valueOf(stringArray[i]), Integer.parseInt(stringArray[i + 1]));
            }
        }
        return hashMap;
    }

    @Override
    public Integer status(String string) throws IOException, ProtocolException {
        return this.statusCommand(string, StatusCommandToken.RECENT, StatusCommandToken.UNSEEN).get((Object)StatusCommandToken.UNSEEN);
    }

    boolean store(String string, MessageFlag[] messageFlagArray) throws IOException {
        boolean bl = false;
        for (MessageFlag messageFlag : messageFlagArray) {
            bl = this.store(string, messageFlag.name());
        }
        return bl;
    }

    boolean store(String string, String string2) throws IOException {
        return this.executeCommand("UID STORE " + string + " +FLAGS.SILENT (\\" + string2 + ")");
    }

    void select(String string) throws IOException, ProtocolException {
        this.select("SELECT", string);
    }

    void examine(String string) throws IOException, ProtocolException {
        this.select("EXAMINE", string);
    }

    private void select(String string, String string2) throws IOException, ProtocolException {
        String string3 = this.tagCommandNum();
        this.passCommand(string3 + " " + string + " \"" + string2 + "\"");
        while ((this.userResponse = this.input.readLine()) != null && !this.isPositiveResponse(this.userResponse, string3)) {
            if (this.isNegativeResponse(this.userResponse, string3)) {
                throw new FolderNotFoundException(this.userResponse);
            }
            if (!this.isBadResponse(this.userResponse, string3)) continue;
            throw new ProtocolException(this.userResponse);
        }
    }

    List<Folder> list() throws IOException {
        String string = this.tagCommandNum();
        this.passCommand(string + " LIST \"/\" \"*\"");
        LinkedList<Folder> linkedList = new LinkedList<Folder>();
        while ((this.userResponse = this.input.readLine()) != null && !this.userResponse.startsWith(string)) {
            String[] stringArray;
            IMAPFolder iMAPFolder = new IMAPFolder();
            this.userResponse = this.userResponse.substring(6, this.userResponse.length()).trim();
            int n = 0;
            for (char n2 : this.userResponse.toCharArray()) {
                ++n;
                if (n2 == ')') break;
            }
            Object object = this.userResponse.substring(0, n);
            object = StringUtil.trimWith((String)object, (String)"(", (String)")");
            for (String string2 : stringArray = ((String)object).split(" ")) {
                iMAPFolder.addAttribute(StringUtil.trimWith((String)string2, (String)"\\", (String)""));
            }
            this.userResponse = this.userResponse.substring(n, this.userResponse.length()).trim();
            String[] stringArray2 = this.userResponse.split(" (?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            String string3 = StringUtil.trimWithDoubleQuote((String)stringArray2[0]);
            String string4 = StringUtil.trimWithDoubleQuote((String)stringArray2[1]);
            iMAPFolder.setName(string4);
            iMAPFolder.setDelimiter(string3);
            int string2 = string4.lastIndexOf(string3);
            iMAPFolder.setLabel(string2 != -1 ? string4.substring(string2 + 1, string4.length()) : string4);
            String[] stringArray3 = string4.split(string3);
            if (stringArray3.length <= 1) {
                linkedList.add(iMAPFolder);
                continue;
            }
            if (stringArray3.length <= 1) continue;
            String string5 = stringArray3[0];
            Folder folder = this.parent(string5, linkedList);
            for (int i = 1; i < stringArray3.length - 1; ++i) {
                string5 = string5 + iMAPFolder.getDelimiter() + stringArray3[i];
                folder = this.parent(string5, folder.getChildren());
            }
            folder.getChildren().add(iMAPFolder);
        }
        return linkedList;
    }

    private Folder parent(String string, List<Folder> list) {
        for (Folder folder : list) {
            if (!folder.getName().equals(string)) continue;
            return folder;
        }
        return null;
    }

    boolean expunge() throws IOException {
        return this.executeCommand("EXPUNGE");
    }

    void copy(int n, String string) throws IOException, ProtocolException {
        if (!this.executeCommand("COPY " + n + " " + "\"" + string + "\"")) {
            throw new ProtocolException("Unable to copy letter [" + n + "] to folder [" + string + "]\n" + this.userResponse);
        }
    }

    void create(String string) throws IOException, ProtocolException {
        if (!this.executeCommand("CREATE \"" + string + "\"")) {
            throw new ProtocolException("Unable to create folder [" + string + "]\n" + this.userResponse);
        }
    }

    void delete(String string) throws IOException, ProtocolException {
        if (!this.executeCommand("DELETE \"" + string + "\"")) {
            throw new ProtocolException("Unable to delete folder [" + string + "]\n" + this.userResponse);
        }
    }

    void rename(String string, String string2) throws IOException, ProtocolException {
        if (!this.executeCommand("RENAME \"" + string + "\" \"" + string2 + "\"")) {
            throw new ProtocolException("Unable to rename folder [" + string + "]\n" + this.userResponse);
        }
    }

    boolean executeCommand(String string) throws IOException {
        return this.executeCommand(string, this.tagCommandNum());
    }

    boolean executeCommand(String string, String string2) throws IOException {
        this.passCommand(string2 + " " + string);
        while ((this.userResponse = this.input.readLine()) != null) {
            if (!this.userResponse.startsWith(string2)) continue;
            return this.isPositiveResponse(this.userResponse, string2);
        }
        return false;
    }

    boolean isPositiveResponse(String string, String string2) {
        return this.isPositiveResponse(string.substring(string2.length() + 1, string.length()));
    }

    boolean isPositiveResponse(String string) {
        return this.isEqualResponse(string, IMAP_RESPONSE_CODE_OK);
    }

    private boolean isBadResponse(String string) {
        return this.isEqualResponse(string, IMAP_RESPONSE_CODE_ERR);
    }

    boolean isBadResponse(String string, String string2) {
        return this.isBadResponse(string.substring(string2.length() + 1, string.length()));
    }

    private boolean isNegativeResponse(String string) {
        return this.isEqualResponse(string, IMAP_RESPONSE_CODE_NO);
    }

    boolean isNegativeResponse(String string, String string2) {
        return this.isNegativeResponse(string.substring(string2.length() + 1, string.length()));
    }

    private boolean isEqualResponse(String string, String string2) {
        return string.toLowerCase().startsWith("* " + string2) || string.toLowerCase().startsWith(string2);
    }

    static enum StatusCommandToken {
        MESSAGES,
        RECENT,
        UIDNEXT,
        UIDVALIDITY,
        UNSEEN;

    }
}

