/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.db.DefaultDAOFactory;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.db.dao.POP3MarkedCacheDAO;
import net.sf.amemailchecker.mail.MessageFlag;
import net.sf.amemailchecker.mail.exception.MessageNotFoundException;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.impl.BaseIngoingClient;
import net.sf.amemailchecker.mail.impl.POP3Protocol;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.impl.letter.RawMessagePart;
import net.sf.amemailchecker.mail.impl.mailbox.POP3Folder;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;
import net.sf.amemailchecker.mail.model.MailBox;
import net.sf.amemailchecker.mail.parser.reader.InputReader;
import net.sf.amemailchecker.mail.parser.reader.POP3Reader;

public class POP3Client
extends BaseIngoingClient {
    private static final Logger logger = Logger.getLogger(POP3Client.class.getName());
    private POP3MarkedCacheDAO markedCacheDAO = DefaultDAOFactory.getInstance().getPOP3MarkedCacheDAO();

    public POP3Client() {
    }

    public POP3Client(POP3Protocol pOP3Protocol) {
        this();
        this.protocol = pOP3Protocol;
    }

    @Override
    public boolean connect() throws IOException {
        String string;
        boolean bl = super.connect();
        if (bl && !(string = this.input.readLine()).startsWith("+OK")) {
            throw new IOException(string);
        }
        return bl;
    }

    @Override
    public Map<Folder, List<Letter>> unread(MailBox mailBox, boolean bl) throws IOException, ProtocolException {
        HashMap<Folder, List<Letter>> hashMap = new HashMap<Folder, List<Letter>>();
        Folder folder = (Folder)mailBox.getFolders().get(0);
        if (!folder.isEnabled()) {
            return hashMap;
        }
        ArrayList<LetterImpl> arrayList = new ArrayList<LetterImpl>();
        int n = ((POP3Protocol)this.protocol).status("INBOX");
        for (int i = 1; i <= n; ++i) {
            LetterImpl letterImpl;
            try {
                letterImpl = this.unread(folder, bl, i);
            }
            catch (ProtocolException protocolException) {
                throw protocolException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                logger.log(Level.INFO, "Unable to process letter with message sequence number: " + i);
                logger.log(Level.SEVERE, exception.getMessage(), exception.getCause());
                continue;
            }
            if (letterImpl == null) continue;
            arrayList.add(letterImpl);
        }
        hashMap.put(folder, arrayList);
        return hashMap;
    }

    private LetterImpl unread(Folder folder, boolean bl, int n) throws IOException, ProtocolException {
        int n2;
        String string = ((POP3Protocol)this.protocol).uidl(n);
        if (this.isMessageChecked(folder, string)) {
            return null;
        }
        try {
            if (this.markedCacheDAO.contains(this.account, string)) {
                return null;
            }
        }
        catch (DataBaseNegotiationException dataBaseNegotiationException) {
            logger.log(Level.SEVERE, dataBaseNegotiationException.getMessage(), dataBaseNegotiationException);
        }
        int n3 = n2 = bl ? 100000 : 0;
        if (!((POP3Protocol)this.protocol).top(n, n2)) {
            return null;
        }
        RawMessagePart rawMessagePart = new RawMessagePart();
        LetterImpl letterImpl = new LetterImpl(rawMessagePart);
        letterImpl.setUid(string);
        POP3Reader pOP3Reader = new POP3Reader(((POP3Protocol)this.protocol).input, ".");
        this.readHeaders(letterImpl, pOP3Reader, bl);
        if (bl) {
            this.readBody(letterImpl, pOP3Reader);
        }
        if (letterImpl.getMessageID() == null) {
            letterImpl.setMessageID(string);
        }
        logger.info("[" + this.account.getTitle() + "] - " + "Reading finished for MsgNum [" + n + "]");
        return letterImpl;
    }

    private void readHeaders(LetterImpl letterImpl, InputReader inputReader, boolean bl) throws IOException {
        this.mailMessageResolver.resolveHeaders(inputReader, letterImpl.getRawMessage(), bl);
        this.mailMessageParser.parseFromHeader(letterImpl);
        this.mailMessageParser.parseSubjectHeader(letterImpl);
        this.mailMessageParser.parseAddresseesHeader(letterImpl, "CC");
        this.mailMessageParser.parseAddresseesHeader(letterImpl, "To");
        this.mailMessageParser.parseDateHeader(letterImpl);
    }

    private void readBody(LetterImpl letterImpl, InputReader inputReader) throws IOException {
        this.mailMessageResolver.resolveRootPart(inputReader, letterImpl);
        this.mailMessageParser.processBody(letterImpl.getRawMessage(), letterImpl);
    }

    public boolean delete(int n) throws IOException {
        return n != -1 && ((POP3Protocol)this.protocol).delete(n);
    }

    private int retrieveIndexByUid(String string) throws IOException, ProtocolException {
        Map<Integer, String> map = ((POP3Protocol)this.protocol).uidl();
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    boolean flag(Folder folder, String string, MessageFlag ... messageFlagArray) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        for (MessageFlag messageFlag : messageFlagArray) {
            if (messageFlag.equals((Object)MessageFlag.Deleted)) {
                bl = true;
            }
            if (!messageFlag.equals((Object)MessageFlag.Seen)) continue;
            bl2 = true;
        }
        if (bl) {
            try {
                int n = this.retrieveIndexByUid(string);
                int n2 = n == -1 || this.delete(n) ? 1 : 0;
                return n2 != 0;
            }
            catch (ProtocolException protocolException) {
                return false;
            }
        }
        if (bl2) {
            try {
                this.markedCacheDAO.insert(this.account, string);
            }
            catch (DataBaseNegotiationException dataBaseNegotiationException) {
                logger.log(Level.SEVERE, dataBaseNegotiationException.getMessage(), dataBaseNegotiationException);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Letter fetchMessage(Folder folder, Letter letter) throws IOException, ProtocolException {
        int n = this.retrieveIndexByUid(letter.getUid());
        if (n == -1) {
            throw new MessageNotFoundException("Message with UID [" + letter.getUid() + "] wasn't found on the server");
        }
        LetterImpl letterImpl = this.unread(folder, true, n);
        ((LetterImpl)letter).getTexts().putAll(letterImpl.getTexts());
        ((LetterImpl)letter).getAttachments().addAll(letterImpl.getAttachments());
        ((LetterImpl)letter).setRawMessage(letterImpl.getRawMessage());
        ((LetterImpl)letter).setInline(letterImpl.getInline());
        return letter;
    }

    @Override
    public List<Folder> listFolders() throws IOException, ProtocolException {
        ArrayList<Folder> arrayList = new ArrayList<Folder>();
        arrayList.add(new POP3Folder());
        return arrayList;
    }

    @Override
    public void createFolder(Folder folder, Folder folder2, String string) throws IOException, ProtocolException {
        throw new ProtocolException("POP3 protocol does not support folder creation");
    }

    @Override
    public void deleteFolder(Folder folder) throws IOException, ProtocolException {
        throw new ProtocolException("POP3 protocol does not support folder deletion");
    }

    @Override
    public String renameFolder(Folder folder, String string) throws IOException, ProtocolException {
        throw new ProtocolException("POP3 protocol does not support folder renaming");
    }

    @Override
    public List<Letter> copy(List<Letter> list, Folder folder, Folder folder2) throws IOException, ProtocolException {
        throw new ProtocolException("POP3 protocol does not support letters copying");
    }
}

