/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.amemailchecker.mail.IMailIngoingProtocol;
import net.sf.amemailchecker.mail.exception.AuthenticationException;
import net.sf.amemailchecker.mail.exception.ExtensionNotSupportedException;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.impl.BaseMailProtocol;
import net.sf.amemailchecker.mail.impl.extension.POP3ExtensionBean;
import net.sf.amemailchecker.mail.parser.CodecUtil;
import net.sf.amemailchecker.util.StringUtil;

public class POP3Protocol
extends BaseMailProtocol
implements IMailIngoingProtocol {
    public static final String POP3_ERROR_RESPONSE_CODE = "-ERR";
    public static final String POP3_OK_RESPONSE_CODE = "+OK";

    @Override
    public boolean login(String string, char[] cArray) throws IOException, ProtocolException {
        try {
            this.capa();
            return this.auth(string, cArray);
        }
        catch (ExtensionNotSupportedException extensionNotSupportedException) {
            boolean bl = this.authSimple(string, cArray);
            if (!bl) {
                throw new AuthenticationException(StringUtil.trimWith((String)this.userResponse, (String)POP3_ERROR_RESPONSE_CODE, (String)""));
            }
            return bl;
        }
    }

    @Override
    public void startTls() throws IOException, ProtocolException {
        try {
            this.capa();
        }
        catch (ExtensionNotSupportedException extensionNotSupportedException) {
            throw new ProtocolException("Cannot start TLS negotiation\nSTARTTLS is not supported by the server");
        }
        if (!this.extensionBean.isExtensionSupported("STLS")) {
            throw new ProtocolException("Cannot start TLS negotiation\nSTARTTLS is not supported by the server");
        }
        String string = this.commandSingleResult("STLS");
        if (this.isNegativeResponse(string)) {
            throw new ProtocolException("Cannot start TLS negotiation");
        }
    }

    private boolean authSimple(String string, char[] cArray) throws IOException {
        boolean bl = this.commandSingleResult("USER " + string, POP3_OK_RESPONSE_CODE);
        if (bl) {
            bl = this.commandSingleResult("PASS " + String.valueOf(cArray), POP3_OK_RESPONSE_CODE);
        }
        return bl;
    }

    @Override
    protected boolean authPlain(String string, char[] cArray) throws IOException {
        String string2 = "\u0000" + string + "\u0000" + String.valueOf(cArray);
        try {
            string2 = CodecUtil.encodeBase64(string2);
            return this.commandSingleResult("AUTH PLAIN " + string2, POP3_OK_RESPONSE_CODE);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public void capa() throws IOException, ExtensionNotSupportedException {
        String string;
        if (!this.commandSingleResult("CAPA", POP3_OK_RESPONSE_CODE)) {
            throw new ExtensionNotSupportedException("Extension does not supported");
        }
        this.extensionBean = new POP3ExtensionBean();
        while ((string = this.input.readLine()) != null && !string.equals(".")) {
            this.extensionBean.addExtension(string);
        }
    }

    public boolean top(int n, int n2) throws IOException {
        return this.commandSingleResult("TOP " + n + " " + n2, POP3_OK_RESPONSE_CODE);
    }

    @Override
    public void quit() throws IOException {
        super.quit();
        this.commandSingleResult("QUIT", POP3_OK_RESPONSE_CODE);
    }

    public boolean retrieve(int n) throws IOException {
        return this.commandSingleResult("RETR " + n, POP3_OK_RESPONSE_CODE);
    }

    public boolean delete(int n) throws IOException {
        return this.commandSingleResult("DELE " + n, POP3_OK_RESPONSE_CODE);
    }

    public boolean reset() throws IOException {
        return this.commandSingleResult("RSET", POP3_OK_RESPONSE_CODE);
    }

    @Override
    public Integer status(String string) throws IOException, ProtocolException {
        if (!string.equalsIgnoreCase("INBOX")) {
            throw new ProtocolException("Invalid folder specified [ " + string + " ].\nOnly [ " + "INBOX" + " ] allowed for POP3.");
        }
        String string2 = this.parseSingleResponse(this.commandSingleResult("STAT"), 1);
        return Integer.parseInt(string2);
    }

    public String uidl(int n) throws IOException, ProtocolException {
        return this.parseSingleResponse(this.commandSingleResult("UIDL " + n), 2);
    }

    public Map<Integer, String> uidl() throws IOException, ProtocolException {
        String string;
        if (!this.commandSingleResult("UIDL", POP3_OK_RESPONSE_CODE)) {
            throw new ProtocolException("");
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        while ((string = this.input.readLine()) != null && !string.equals(".")) {
            String[] stringArray = string.split(" ");
            hashMap.put(Integer.valueOf(stringArray[0]), stringArray[1]);
        }
        return hashMap;
    }

    private String parseSingleResponse(String string, int n) throws ProtocolException {
        if (!string.startsWith(POP3_OK_RESPONSE_CODE)) {
            throw new ProtocolException(string);
        }
        return string.split(" ")[n];
    }

    boolean isNegativeResponse(String string) {
        return StringUtil.indexOfIgnoreCase((String)string, (String)POP3_ERROR_RESPONSE_CODE) != -1;
    }
}

