/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.impl;

import java.io.IOException;
import java.util.List;
import net.sf.amemailchecker.mail.IMailOutgoingClient;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.impl.BaseOutgoingClient;
import net.sf.amemailchecker.mail.impl.SMTPProtocol;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.PostalAddressee;

public class SMTPClient
extends BaseOutgoingClient
implements IMailOutgoingClient {
    public SMTPClient(SMTPProtocol sMTPProtocol) {
        this.protocol = sMTPProtocol;
    }

    @Override
    public boolean connect() throws IOException {
        String string;
        boolean bl = super.connect();
        if (bl && !(string = this.input.readLine()).startsWith("220")) {
            throw new IOException(string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(LetterImpl letterImpl) throws IOException, ProtocolException {
        SMTPClient sMTPClient = this;
        synchronized (sMTPClient) {
            this.connect();
            boolean bl = this.protocol.login(this.account.getUserCredentials().getUserName(), this.account.getUserCredentials().getPassword());
            if (!bl) {
                throw new ProtocolException(this.protocol.getUserResponse());
            }
            ((SMTPProtocol)this.protocol).mail("<" + this.account.getEmailAddress() + ">");
            this.sendRecipients(letterImpl, "To");
            this.sendRecipients(letterImpl, "CC");
            ((SMTPProtocol)this.protocol).data();
            this.mailMessageComposer.composeData(((SMTPProtocol)this.protocol).output, letterImpl);
            ((SMTPProtocol)this.protocol).terminate();
            this.protocol.quit();
            this.disconnect();
        }
    }

    private void sendRecipients(LetterImpl letterImpl, String string) throws IOException {
        List<PostalAddressee> list = letterImpl.getRecipients(string);
        if (list != null) {
            for (PostalAddressee postalAddressee : list) {
                ((SMTPProtocol)this.protocol).rcpt("<" + postalAddressee.getAddress() + ">");
            }
        }
    }
}

