/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.impl;

import java.io.IOException;
import net.sf.amemailchecker.mail.IMailProtocol;
import net.sf.amemailchecker.mail.exception.AuthenticationException;
import net.sf.amemailchecker.mail.exception.ExtensionNotSupportedException;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.impl.BaseMailProtocol;
import net.sf.amemailchecker.mail.impl.extension.SMTPExtensionBean;
import net.sf.amemailchecker.mail.parser.CodecUtil;

public class SMTPProtocol
extends BaseMailProtocol
implements IMailProtocol {
    @Override
    public boolean login(String string, char[] cArray) throws IOException, ProtocolException {
        try {
            this.ehlo(this.getDomain());
            boolean bl = this.auth(string, cArray);
            if (!bl) {
                throw new AuthenticationException(this.userResponse);
            }
            return bl;
        }
        catch (ExtensionNotSupportedException extensionNotSupportedException) {
            return this.helo(this.getDomain());
        }
    }

    @Override
    public void quit() throws IOException {
        this.extensionBean.clearExtensionList();
        this.commandSingleResult("QUIT", "221");
    }

    @Override
    public void startTls() throws IOException, ProtocolException {
        this.helo(this.getDomain());
        boolean bl = this.commandSingleResult("STARTTLS", "220");
        if (!bl) {
            if (this.userResponse.startsWith("501")) {
                throw new ProtocolException("STARTTLS is not allowed by SMTP server");
            }
            if (this.userResponse.startsWith("454")) {
                throw new ProtocolException("TLS not available due to temporary reason");
            }
        }
    }

    public boolean helo(String string) throws IOException {
        return this.commandSingleResult("HELO " + string, "250");
    }

    public void ehlo(String string) throws IOException, ExtensionNotSupportedException {
        String string2;
        boolean bl = this.commandSingleResult("EHLO " + string, "250");
        if (!bl) {
            throw new ExtensionNotSupportedException("Extension does not supported");
        }
        this.extensionBean = new SMTPExtensionBean();
        while ((string2 = this.input.readLine()) != null) {
            this.extensionBean.addExtension(string2.substring(4, string2.length()));
            if (string2.substring(0, 4).endsWith("-")) continue;
            break;
        }
    }

    @Override
    public boolean auth(String string, char[] cArray) throws IOException, ExtensionNotSupportedException {
        if (this.extensionBean.isAuthTypeSupported("LOGIN")) {
            return this.authLogin(string, cArray);
        }
        return super.auth(string, cArray);
    }

    private boolean authLogin(String string, char[] cArray) throws IOException {
        boolean bl = this.commandSingleResult("AUTH LOGIN", "334");
        try {
            if (bl) {
                bl = this.commandSingleResult(CodecUtil.encodeBase64(string), "334");
            }
            if (bl) {
                bl = this.commandSingleResult(CodecUtil.encodeBase64(String.valueOf(cArray)), "235");
            }
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        return bl;
    }

    @Override
    protected boolean authPlain(String string, char[] cArray) throws IOException {
        String string2 = "\u0000" + string + "\u0000" + String.valueOf(cArray);
        try {
            string2 = CodecUtil.encodeBase64(string2);
            return this.commandSingleResult("AUTH PLAIN " + string2, "235");
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public boolean mail(String string) throws IOException {
        return this.commandSingleResult("MAIL FROM:" + string, "250");
    }

    public boolean rcpt(String string) throws IOException {
        return this.commandSingleResult("RCPT TO:" + string, "250");
    }

    public boolean rset() throws IOException {
        return this.commandSingleResult("RSET", "250");
    }

    public void data() throws IOException, ProtocolException {
        String string = this.commandSingleResult("DATA");
        if (!string.startsWith("354") && !string.startsWith("250")) {
            this.rset();
            throw new ProtocolException(string);
        }
    }

    public void terminate() throws IOException, ProtocolException {
        boolean bl = this.commandSingleResult(".", "250");
        if (!bl) {
            this.rset();
            throw new ProtocolException("");
        }
    }
}

