/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.impl.letter;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.amemailchecker.mail.MessageFlag;
import net.sf.amemailchecker.mail.impl.letter.RawMessagePart;
import net.sf.amemailchecker.mail.model.Attachment;
import net.sf.amemailchecker.mail.model.Letter;
import net.sf.amemailchecker.mail.model.PostalAddressee;

public class LetterImpl
implements Letter {
    private String uid;
    private PostalAddressee sender;
    private String subject;
    private Date date;
    private Map<String, List<PostalAddressee>> recipients = new HashMap<String, List<PostalAddressee>>();
    private Map<String, String> texts;
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private List<Attachment> inline;
    private Set<MessageFlag> flags;
    private RawMessagePart rawMessage;

    public LetterImpl() {
        this.texts = new HashMap<String, String>();
        this.flags = new HashSet<MessageFlag>();
        this.inline = new ArrayList<Attachment>();
    }

    public LetterImpl(RawMessagePart rawMessagePart) {
        this();
        this.rawMessage = rawMessagePart;
    }

    public LetterImpl(LetterImpl letterImpl, boolean bl) {
        this();
        this.uid = letterImpl.getUid();
        this.sender = letterImpl.getSender();
        this.date = letterImpl.getDate();
        this.subject = letterImpl.getSubject();
        this.texts.putAll(letterImpl.getTexts());
        this.inline.addAll(letterImpl.getInline());
        if (bl) {
            this.attachments.addAll(letterImpl.getAttachments());
        }
        for (String string : letterImpl.recipients.keySet()) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(letterImpl.recipients.get(string));
            this.recipients.put(string, arrayList);
        }
    }

    public LetterImpl(LetterImpl letterImpl, boolean bl, boolean bl2) {
        this(letterImpl, bl);
        if (bl2) {
            this.rawMessage = new RawMessagePart(letterImpl.getRawMessage());
        }
        if (letterImpl.getTexts() != null) {
            this.texts.putAll(letterImpl.getTexts());
        }
        this.flags.addAll(letterImpl.getFlags());
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String string) {
        this.uid = string;
    }

    public PostalAddressee getSender() {
        return this.sender;
    }

    public void setSender(PostalAddressee postalAddressee) {
        this.sender = postalAddressee;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public List<PostalAddressee> getRecipients(String string) {
        return this.recipients.get(string);
    }

    public void setRecipients(String string, List<PostalAddressee> list) {
        this.recipients.put(string, list);
    }

    public boolean hasRecipients(String string) {
        return this.recipients.containsKey(string);
    }

    public Map<String, String> getTexts() {
        return this.texts;
    }

    public String getText(String string) {
        return this.texts.get(string);
    }

    public void setText(String string, String string2) {
        this.texts.put(string, string2);
    }

    public boolean hasTexts() {
        return this.texts != null && this.texts.size() > 0;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public boolean hasAttachments() {
        return this.attachments != null && this.attachments.size() > 0;
    }

    public Set<MessageFlag> getFlags() {
        return this.flags;
    }

    public void addFlag(MessageFlag messageFlag) {
        this.flags.add(messageFlag);
    }

    public RawMessagePart getRawMessage() {
        return this.rawMessage;
    }

    public void setRawMessage(RawMessagePart rawMessagePart) {
        this.rawMessage = rawMessagePart;
    }

    public List<Attachment> getInline() {
        return this.inline;
    }

    public void setInline(List<Attachment> list) {
        this.inline = list;
    }

    public boolean isFetched() {
        return this.flags.contains((Object)MessageFlag.Fetched) || this.flags.contains((Object)MessageFlag.Fetching);
    }

    public String getMessageID() {
        return this.rawMessage != null ? this.rawMessage.getHeaderValue("Message-ID") : null;
    }

    public void setMessageID(String string) {
        this.rawMessage.getHeaders().put("Message-ID", string);
    }

    public boolean isMimeMessage() {
        return this.rawMessage.getHeaders().containsKey("MIME-Version");
    }

    public boolean isMimeMultipart() {
        return this.isMimeMessage() && this.rawMessage.isMultipartBound(this.rawMessage.getHeaderValue("Content-Type"));
    }

    public boolean equals(Object object) {
        return object instanceof LetterImpl && ((LetterImpl)object).getMessageID().equals(this.getMessageID()) && ((LetterImpl)object).getUid().equals(this.uid);
    }
}

