/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.impl.letter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.amemailchecker.util.StringUtil;

public class RawMessagePart {
    private List<String> payload;
    private List<RawMessagePart> bodyParts;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected RawMessagePart rootBodyPart;

    public RawMessagePart() {
    }

    public RawMessagePart(RawMessagePart rawMessagePart) {
        if (rawMessagePart == null) {
            return;
        }
        this.headers = new HashMap<String, String>(rawMessagePart.getHeaders());
        this.payload = new ArrayList<String>(rawMessagePart.getPayload());
        this.bodyParts = new ArrayList<RawMessagePart>();
        for (RawMessagePart rawMessagePart2 : rawMessagePart.getBodyParts()) {
            this.bodyParts.add(new RawMessagePart(rawMessagePart2));
        }
        if (rawMessagePart.getRootBodyPart() != null) {
            this.rootBodyPart = rawMessagePart.getRootBodyPart();
        }
    }

    public RawMessagePart getRootBodyPart() {
        return this.rootBodyPart;
    }

    public void setRootBodyPart(RawMessagePart rawMessagePart) {
        this.rootBodyPart = rawMessagePart;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> map) {
        this.headers = map;
    }

    public boolean containsMimeHeaders() {
        return this.headers.containsKey("Content-Type") && this.headers.containsKey("Content-Transfer-Encoding");
    }

    public boolean containsHeader(String string) {
        return this.headers.containsKey(string);
    }

    public String getHeaderValue(String string) {
        for (String string2 : this.headers.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return this.headers.get(string2);
        }
        return null;
    }

    public boolean isMultipartBound(String string) {
        return string != null && StringUtil.indexOfIgnoreCase((String)string, (String)"multipart") != -1;
    }

    public String getContentType() {
        return this.getHeaderValue("Content-Type");
    }

    public void setContentType(String string) {
        this.headers.put("Content-Type", string);
    }

    public String getContentTransferEncoding() {
        return this.getHeaderValue("Content-Transfer-Encoding");
    }

    public void setContentTransferEncoding(String string) {
        this.headers.put("Content-Transfer-Encoding", string);
    }

    public String getContentDisposition() {
        return this.headers.get("Content-Disposition");
    }

    public void setContentDisposition(String string) {
        this.headers.put("Content-Disposition", string);
    }

    public List<String> getPayload() {
        if (this.payload == null) {
            this.payload = new ArrayList<String>();
        }
        return this.payload;
    }

    public void insertPayloadLine(String string) {
        this.getPayload().add(string);
    }

    public boolean isMultipartBound() {
        return this.isMultipartBound(this.getContentType());
    }

    public String getBoundary() {
        String string = this.getContentType();
        int n = StringUtil.indexOfIgnoreCase((String)string, (String)"boundary");
        if (n != -1) {
            String string2 = string.substring(n + "boundary".length() + 1, string.length());
            int n2 = string2.indexOf(59);
            if (n2 != -1) {
                string2 = string2.substring(0, n2).trim();
            }
            if (string2.startsWith("=")) {
                string2 = StringUtil.trimWith((String)string2, (String)"=", (String)"").trim();
            }
            return StringUtil.trimWithDoubleQuote((String)string2);
        }
        return null;
    }

    public String getContentTypeValue() {
        String string = this.getContentType();
        return string.substring(0, string.indexOf("/"));
    }

    public String getContentSubTypeValue() {
        String string = this.getContentType();
        return string.substring(string.indexOf("/") + 1, string.indexOf(";") != -1 ? string.indexOf(";") : string.length());
    }

    public String getContentTypeNameValue() {
        String string = this.getContentType();
        return StringUtil.trimWithDoubleQuote((String)string.substring(string.indexOf("name") + "name".length() + 1, string.length()));
    }

    public String getContentDispositionType() {
        String string = this.getContentDisposition();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(";");
        return n > 0 ? string.substring(0, string.indexOf(";")).trim() : string;
    }

    public String getContentDispositionTypeNameValue() {
        String[] stringArray;
        String string = this.getContentDisposition();
        if (string == null) {
            return null;
        }
        for (String string2 : stringArray = string.split("[;]")) {
            if (!string2.startsWith("filename")) continue;
            return StringUtil.trimWithDoubleQuote((String)string2.substring("filename".length() + 1, string2.length()));
        }
        return null;
    }

    public List<RawMessagePart> getBodyParts() {
        if (this.bodyParts == null) {
            this.bodyParts = new ArrayList<RawMessagePart>();
        }
        return this.bodyParts;
    }
}

