/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.parser;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import net.sf.amemailchecker.mail.parser.CodecException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.QuotedPrintableCodec;

public class CodecUtil {
    public static String decodeQuotedPrintable(String string, String string2) throws CodecException {
        byte[] byArray = string2.getBytes();
        try {
            byArray = QuotedPrintableCodec.decodeQuotedPrintable((byte[])byArray);
        }
        catch (DecoderException decoderException) {
            throw new CodecException(decoderException);
        }
        return CodecUtil.convertForCharset(byArray, string);
    }

    public static String encodeQuotedPrintable(String string, String string2) throws CodecException {
        byte[] byArray;
        try {
            byArray = QuotedPrintableCodec.encodeQuotedPrintable((BitSet)new BitSet(), (byte[])string.getBytes(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodecException(unsupportedEncodingException);
        }
        return new String(byArray);
    }

    public static byte[] decodeBase64(String string) throws CodecException {
        byte[] byArray = string.getBytes();
        try {
            byArray = Base64.decodeBase64((byte[])byArray);
        }
        catch (Exception exception) {
            throw new CodecException(exception);
        }
        return byArray;
    }

    public static String decodeBase64(String string, String string2) throws CodecException {
        return CodecUtil.convertForCharset(CodecUtil.decodeBase64(string2), string);
    }

    public static byte[] encodeBase64(byte[] byArray) throws CodecException {
        try {
            return Base64.encodeBase64((byte[])byArray);
        }
        catch (Exception exception) {
            throw new CodecException(exception);
        }
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl, boolean bl2) throws CodecException {
        try {
            return Base64.encodeBase64((byte[])byArray, (boolean)bl, (boolean)bl2);
        }
        catch (Exception exception) {
            throw new CodecException(exception);
        }
    }

    public static String encodeBase64(String string) throws CodecException {
        return new String(CodecUtil.encodeBase64(string.getBytes()));
    }

    public static String encodeBase64(String string, String string2) throws CodecException {
        try {
            return new String(CodecUtil.encodeBase64(string.getBytes(string2)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodecException(unsupportedEncodingException);
        }
    }

    public static String encodeBase64(String string, String string2, boolean bl, boolean bl2) throws CodecException {
        try {
            return new String(CodecUtil.encodeBase64(string.getBytes(string2), bl, bl2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodecException(unsupportedEncodingException);
        }
    }

    public static String convertForCharset(byte[] byArray, String string) {
        String string2;
        try {
            string2 = new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String(byArray);
        }
        return string2;
    }

    public static String getDefaultCharset() {
        return System.getProperty("file.encoding");
    }
}

