/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.parser;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.amemailchecker.mail.MimeConstants;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.Attachment;
import net.sf.amemailchecker.mail.parser.CodecException;
import net.sf.amemailchecker.mail.parser.CodecUtil;
import net.sf.amemailchecker.mail.parser.composer.MimeOutputTokenizer;
import net.sf.amemailchecker.mail.parser.composer.MultipleTokenHeaderComposer;
import net.sf.amemailchecker.mail.parser.composer.OutputTokenizer;
import net.sf.amemailchecker.mail.parser.composer.RecipientHeaderComposer;
import net.sf.amemailchecker.mail.parser.composer.StreamOutputTokenizer;
import net.sf.amemailchecker.mail.parser.composer.StringHeaderComposer;
import net.sf.amemailchecker.mail.parser.mime.BoundaryGenerator;

public class MailMessageComposer {
    private static final Logger logger = Logger.getLogger(MailMessageComposer.class.getName());

    public void composeData(Writer writer, LetterImpl letterImpl) throws IOException {
        String string2;
        String[] stringArray = new String[]{"To", "CC"};
        RecipientHeaderComposer recipientHeaderComposer = new RecipientHeaderComposer();
        recipientHeaderComposer.reuseFor(letterImpl.getSender(), "From");
        this.writeTokens(writer, recipientHeaderComposer);
        for (String string2 : stringArray) {
            recipientHeaderComposer.reuseFor(letterImpl, string2);
            this.writeTokens(writer, recipientHeaderComposer);
        }
        StringHeaderComposer stringHeaderComposer = new StringHeaderComposer();
        stringHeaderComposer.reuseFor("Subject", letterImpl.getSubject());
        this.writeTokens(writer, stringHeaderComposer);
        stringHeaderComposer.reuseFor("Date", MimeConstants.DATE_FORMAT.format(new Date()));
        this.writeTokens(writer, stringHeaderComposer);
        BoundaryGenerator boundaryGenerator = new BoundaryGenerator();
        String string3 = boundaryGenerator.generate();
        string2 = "--" + string3;
        String string4 = string2 + "--";
        writer.write("MIME-Version: 1.0\r\n");
        MultipleTokenHeaderComposer multipleTokenHeaderComposer = new MultipleTokenHeaderComposer();
        multipleTokenHeaderComposer.reuseFor(new String[]{"Content-Type", "boundary"}, new String[]{"multipart/alternative", string3});
        this.writeTokens(writer, multipleTokenHeaderComposer);
        writer.write("\r\n");
        this.writeText(writer, letterImpl, string2);
        for (Attachment attachment : letterImpl.getAttachments()) {
            writer.write(string2 + "\r\n");
            multipleTokenHeaderComposer.reuseFor(new String[]{"Content-Type", "name"}, new String[]{"application/octet-stream", attachment.getName()});
            this.writeTokens(writer, multipleTokenHeaderComposer);
            multipleTokenHeaderComposer.reuseFor(new String[]{"Content-Disposition", "filename"}, new String[]{"attachment", attachment.getName()});
            this.writeTokens(writer, multipleTokenHeaderComposer);
            writer.write("Content-Transfer-Encoding: base64\r\n");
            writer.write("\r\n");
            StreamOutputTokenizer streamOutputTokenizer = new StreamOutputTokenizer();
            streamOutputTokenizer.reuseFor(attachment.getData() != null ? new ByteArrayInputStream(attachment.getData()) : new FileInputStream(attachment.getFile()));
            this.writeTokens(writer, streamOutputTokenizer);
            writer.write("\r\n");
        }
        writer.write(string4 + "\r\n");
    }

    private void writeTokens(Writer writer, OutputTokenizer outputTokenizer) throws IOException {
        String string;
        while ((string = outputTokenizer.readNextToken()) != null) {
            writer.write(string + "\r\n");
        }
    }

    private void writeText(Writer writer, LetterImpl letterImpl, String string) throws IOException {
        Map<String, String> map = letterImpl.getTexts();
        Set<String> set = map.keySet();
        MimeOutputTokenizer mimeOutputTokenizer = new MimeOutputTokenizer();
        for (String string2 : set) {
            writer.write(string + "\r\n");
            writer.write("Content-Type: " + string2 + "; charset=" + CodecUtil.getDefaultCharset() + "\r\n");
            writer.write("Content-Transfer-Encoding: base64\r\n");
            writer.write("\r\n");
            mimeOutputTokenizer.reuseFor(letterImpl.getText(string2));
            this.writeTokens(writer, mimeOutputTokenizer);
            writer.write("\r\n");
        }
    }

    public List<String> encodeFile(byte[] byArray) throws CodecException {
        char[] cArray = new String(CodecUtil.encodeBase64(byArray)).toCharArray();
        return this.dropToTokens(cArray);
    }

    public List<String> encodeBody(String string) throws CodecException {
        String string2 = CodecUtil.encodeBase64(string, CodecUtil.getDefaultCharset());
        return this.dropToTokens(string2.toCharArray());
    }

    private List<String> dropToTokens(char[] cArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        double d = (double)cArray.length / 76.0;
        BigDecimal bigDecimal = new BigDecimal(d);
        int n = bigDecimal.scale() > 0 ? (int)d + 1 : (int)d;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = cArray.length - n2 > 76 ? n2 + 76 : cArray.length - 1;
            arrayList.add(String.valueOf(Arrays.copyOfRange(cArray, n2, n3)));
            n2 += 76;
        }
        return arrayList;
    }
}

