/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.parser;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.mail.MimeConstants;
import net.sf.amemailchecker.mail.cache.PostalAddresseeCache;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.impl.letter.RawMessagePart;
import net.sf.amemailchecker.mail.model.Addressee;
import net.sf.amemailchecker.mail.model.Attachment;
import net.sf.amemailchecker.mail.model.PostalAddressee;
import net.sf.amemailchecker.mail.parser.CodecException;
import net.sf.amemailchecker.mail.parser.CodecUtil;
import net.sf.amemailchecker.util.StringUtil;

public class MailMessageParser {
    private static Logger logger = Logger.getLogger(MailMessageParser.class.getName());

    public void parseDateHeader(LetterImpl letterImpl) {
        if (!letterImpl.getRawMessage().containsHeader("Date")) {
            letterImpl.getRawMessage().getHeaders().put("Date", MimeConstants.DATE_FORMAT.format(new Date()));
        }
        String string = letterImpl.getRawMessage().getHeaders().get("Date");
        try {
            letterImpl.setDate(MimeConstants.DATE_FORMAT.parse(string));
        }
        catch (ParseException parseException) {
            for (int i = MimeConstants.rfc822DateFormats.length - 1; i >= 0; --i) {
                try {
                    letterImpl.setDate(MimeConstants.rfc822DateFormats[i].parse(string));
                    break;
                }
                catch (ParseException parseException2) {
                    if (i != 0) continue;
                    logger.severe("Unable to parse date [" + string + "] for letter [" + letterImpl.getMessageID() + "]");
                    continue;
                }
            }
        }
    }

    public void parseSubjectHeader(LetterImpl letterImpl) {
        String string = letterImpl.getRawMessage().getHeaders().get("Subject");
        if (string == null) {
            letterImpl.setSubject("[ No Subject ]");
            return;
        }
        if (string.trim().indexOf("=?") == -1) {
            letterImpl.setSubject(string);
            return;
        }
        letterImpl.setSubject(this.getDecodedHeaderValue(string));
    }

    public void parseFromHeader(LetterImpl letterImpl) {
        List<PostalAddressee> list = this.parseRecipients(letterImpl, "From");
        letterImpl.setSender(list.get(0));
    }

    public void parseAddresseesHeader(LetterImpl letterImpl, String string) {
        List<PostalAddressee> list = this.parseRecipients(letterImpl, string);
        if (list != null) {
            letterImpl.setRecipients(string, list);
        }
    }

    public List<PostalAddressee> parseRecipients(LetterImpl letterImpl, String string) {
        String[] stringArray;
        String string2 = letterImpl.getRawMessage().getHeaders().get(string);
        if (string2 == null || string2.equals("")) {
            return null;
        }
        ArrayList<PostalAddressee> arrayList = new ArrayList<PostalAddressee>();
        for (String string3 : stringArray = string2.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
            if ((string3 = string3.trim()).equals("")) continue;
            String string4 = "";
            String string5 = "";
            int n = string3.indexOf(60);
            if (n != -1) {
                string5 = this.getDecodedHeaderValue(string3.substring(0, n).trim());
                string5 = StringUtil.trimWithDoubleQuote((String)string5);
                string4 = string3.substring(n + 1, string3.length() - 1).trim();
            } else if (string3.indexOf(32) == -1 && string3.indexOf(64) != -1) {
                string4 = string3;
            } else {
                string5 = string3;
            }
            PostalAddressee postalAddressee = null;
            if (!string4.equals("")) {
                postalAddressee = PostalAddresseeCache.Instance.findByAddress(string4);
            }
            if (postalAddressee == null) {
                postalAddressee = new Addressee();
                postalAddressee.setLabel(string5);
                ((Addressee)postalAddressee).setAddress(string4);
                PostalAddresseeCache.Instance.add(postalAddressee);
            }
            arrayList.add(postalAddressee);
        }
        return arrayList;
    }

    public void processBody(RawMessagePart rawMessagePart, LetterImpl letterImpl) {
        if (rawMessagePart.isMultipartBound()) {
            for (RawMessagePart rawMessagePart2 : rawMessagePart.getBodyParts()) {
                this.processBody(rawMessagePart2, letterImpl);
            }
        } else {
            String string = rawMessagePart.getContentType();
            if (string == null) {
                return;
            }
            if (!this.textType(string) || rawMessagePart.getContentDisposition() != null) {
                Attachment attachment = new Attachment();
                attachment.setType(rawMessagePart.getContentTypeValue());
                attachment.setSubType(rawMessagePart.getContentSubTypeValue());
                attachment.setName(this.getDecodedHeaderValue(rawMessagePart.getContentTypeNameValue()));
                attachment.setData(this.decodeBinary(StringUtil.appendTokens(rawMessagePart.getPayload()), rawMessagePart.getContentTransferEncoding()));
                String string2 = rawMessagePart.getContentDispositionType();
                attachment.setDisposition(string2 == null ? "inline" : string2);
                List<Attachment> list = attachment.getDisposition().equals("attachment") ? letterImpl.getAttachments() : letterImpl.getInline();
                list.add(attachment);
                return;
            }
            String string3 = string.split("=").length > 1 ? StringUtil.trimWithDoubleQuote((String)string.split("=")[1].trim()) : CodecUtil.getDefaultCharset();
            String string4 = rawMessagePart.getContentTransferEncoding();
            string4 = string4 != null ? StringUtil.trimWithDoubleQuote((String)rawMessagePart.getContentTransferEncoding().trim()) : "7bit";
            String string5 = this.decodeBody(rawMessagePart.getPayload(), string4, string3, StringUtil.indexOfIgnoreCase((String)string, (String)"text/plain") != -1);
            letterImpl.setText(StringUtil.indexOfIgnoreCase((String)string, (String)"text/plain") != -1 ? "text/plain" : "text/html", string5);
        }
    }

    public byte[] decodeBinary(String string, String string2) {
        try {
            if (string2.equalsIgnoreCase("base64")) {
                return CodecUtil.decodeBase64(string);
            }
        }
        catch (CodecException codecException) {
            logger.log(Level.SEVERE, codecException.getMessage(), codecException);
        }
        return string.getBytes();
    }

    public String getDecodedHeaderValue(String string) {
        boolean bl = (string = string.trim()).indexOf("=?") != -1;
        boolean bl2 = string.startsWith("=?");
        if (!bl2 && !bl) {
            return string;
        }
        if (bl && !bl2) {
            String[] stringArray;
            String string2 = "";
            for (String string3 : stringArray = string.split("[ ]")) {
                string2 = string2 + this.getDecodedHeaderValueInt(string3);
                string2 = string2 + " ";
            }
            return string2;
        }
        return this.getDecodedHeaderValueInt(string);
    }

    private String getDecodedHeaderValueInt(String string) {
        if (!string.startsWith("=?")) {
            return string;
        }
        String[] stringArray = string.substring(2, string.length() - 2).split("[?]");
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        if (stringArray.length > 4) {
            for (int i = 6; i < stringArray.length; i += 4) {
                String string5 = stringArray[i];
                string4 = string4 + string5;
            }
        }
        return this.getDecodedHeaderValue(string4, string2, string3);
    }

    public String getDecodedHeaderValue(String string, String string2, String string3) {
        try {
            if (string3.equalsIgnoreCase("Q")) {
                string = CodecUtil.decodeQuotedPrintable(string2, string);
            }
            if (string3.equalsIgnoreCase("B")) {
                String[] stringArray = string.split("[==]");
                string = "";
                for (String string4 : stringArray) {
                    string = string + CodecUtil.decodeBase64(string2, string4);
                }
            }
        }
        catch (CodecException codecException) {
            logger.log(Level.SEVERE, codecException.getMessage(), codecException.getCause());
        }
        return string;
    }

    public String decodeBody(List<String> list, String string, String string2, boolean bl) {
        if (!this.needsDecode(string)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : list) {
                stringBuilder.append(CodecUtil.convertForCharset(string3.getBytes(), string2));
                if (!bl) continue;
                stringBuilder.append("\r\n");
            }
            return stringBuilder.toString();
        }
        String string4 = "";
        try {
            if (string.equalsIgnoreCase("base64")) {
                string4 = CodecUtil.decodeBase64(string2, StringUtil.appendTokens(list));
            }
            if (string.equalsIgnoreCase("quoted-printable")) {
                string4 = CodecUtil.decodeQuotedPrintable(string2, StringUtil.appendTokensTerminate(list, (String)"="));
            }
        }
        catch (CodecException codecException) {
            logger.log(Level.SEVERE, codecException.getMessage(), codecException.getCause());
            string4 = StringUtil.appendTokens(list);
        }
        return string4;
    }

    public String decodeFolderName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = -1;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c != '&' && n == -1) {
                stringBuffer.append(c);
                continue;
            }
            if (c == '&' && cArray[i + 1] == '-') {
                stringBuffer.append('&');
                ++i;
                continue;
            }
            if (c == '&') {
                n = i + 1;
                continue;
            }
            if (c != '-' || n == -1) continue;
            String string2 = string.substring(n, i).replaceAll("[,]", "[/]");
            try {
                string2 = CodecUtil.decodeBase64("UnicodeBigUnmarked", string2);
            }
            catch (CodecException codecException) {
                logger.log(Level.WARNING, "Unable to decode folder name value " + string2, codecException);
            }
            stringBuffer.append(string2);
            n = -1;
        }
        return stringBuffer.toString();
    }

    public String encodeFolderName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = -1;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            boolean bl = StringUtil.isAscii((char)c);
            if (c == '&' && n != -1) {
                stringBuffer.append(this.encodeChunkForFolderName(string, n, i));
                n = -1;
            }
            if (c == '&') {
                stringBuffer.append("&-");
                continue;
            }
            if (n == -1 && !bl) {
                n = i;
            }
            if (n != -1 && bl) {
                stringBuffer.append(this.encodeChunkForFolderName(string, n, i));
                n = -1;
            }
            if (bl) {
                stringBuffer.append(c);
            }
            if (i != cArray.length - 1 || n == -1) continue;
            stringBuffer.append(this.encodeChunkForFolderName(string, n, string.length()));
            n = -1;
        }
        return stringBuffer.toString();
    }

    private String encodeChunkForFolderName(String string, int n, int n2) {
        String string2 = string.substring(n, n2);
        try {
            string2 = CodecUtil.encodeBase64(string2, "UnicodeBigUnmarked", false, true);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Unable to encode folder name value " + string2, exception);
            return string2;
        }
        return "&" + string2.replaceAll("[_]", ",") + "-";
    }

    private boolean needsDecode(String string) {
        return !string.equalsIgnoreCase("8bit") && !string.equalsIgnoreCase("7bit") && !string.equalsIgnoreCase("binary");
    }

    private boolean textType(String string) {
        return StringUtil.indexOfIgnoreCase((String)string, (String)"text/plain") != -1 || StringUtil.indexOfIgnoreCase((String)string, (String)"text/html") != -1;
    }
}

