/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.parser;

import java.io.IOException;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.impl.letter.RawMessagePart;
import net.sf.amemailchecker.mail.parser.mime.HeaderContentHandler;
import net.sf.amemailchecker.mail.parser.mime.MimeMultipartBodyContentHandler;
import net.sf.amemailchecker.mail.parser.mime.SimpleBodyContentHandler;
import net.sf.amemailchecker.mail.parser.reader.InputReader;

public class MailMessageResolver {
    private HeaderContentHandler headerContentHandler = new HeaderContentHandler();

    public void resolveHeader(String string, String string2, RawMessagePart rawMessagePart) {
        this.headerContentHandler.handleMessageHeader(string, string2, rawMessagePart);
    }

    public void resolveHeaders(InputReader inputReader, RawMessagePart rawMessagePart) throws IOException {
        this.resolveHeaders(inputReader, rawMessagePart, true);
    }

    public void resolveHeaders(InputReader inputReader, RawMessagePart rawMessagePart, boolean bl) throws IOException {
        rawMessagePart.setHeaders(this.headerContentHandler.handleHeaders(inputReader, bl));
        this.headerContentHandler.flush();
    }

    public void resolveRootPart(InputReader inputReader, LetterImpl letterImpl) throws IOException {
        RawMessagePart rawMessagePart = letterImpl.getRawMessage();
        if (letterImpl.isMimeMessage() && letterImpl.isMimeMultipart()) {
            new MimeMultipartBodyContentHandler().handle(inputReader, rawMessagePart);
        } else if (letterImpl.isMimeMessage() && !letterImpl.isMimeMultipart() || rawMessagePart.containsMimeHeaders()) {
            new SimpleBodyContentHandler().handle(inputReader, rawMessagePart);
        } else {
            rawMessagePart.setContentType("text/plain");
            rawMessagePart.setContentTransferEncoding("7bit");
            new SimpleBodyContentHandler().handle(inputReader, rawMessagePart);
        }
    }
}

