/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.parser.composer;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.mail.parser.CodecException;
import net.sf.amemailchecker.mail.parser.CodecUtil;
import net.sf.amemailchecker.mail.parser.composer.OutputTokenizer;

public class MimeOutputTokenizer
implements OutputTokenizer {
    private static final Logger logger = Logger.getLogger(MimeOutputTokenizer.class.getName());
    private String input;
    private int currentPos;
    private int maxLength;

    public void reuseFor(String string) {
        if (this.input != null && this.currentPos > 0) {
            throw new IllegalStateException("Cannot be reused while active");
        }
        try {
            this.input = CodecUtil.encodeBase64(string);
        }
        catch (CodecException codecException) {
            logger.log(Level.SEVERE, codecException.getMessage(), codecException);
        }
        this.maxLength = this.input.length();
    }

    @Override
    public String readNextToken() {
        if (this.maxLength == this.currentPos) {
            this.input = null;
            this.currentPos = 0;
            return null;
        }
        int n = this.currentPos + 76;
        n = n > this.maxLength ? this.maxLength : n;
        String string = this.input.substring(this.currentPos, n);
        this.currentPos = n;
        return string;
    }
}

