/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.parser.composer;

import java.util.ArrayList;
import java.util.List;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.PostalAddressee;
import net.sf.amemailchecker.mail.parser.composer.BaseHeaderComposer;
import net.sf.amemailchecker.mail.parser.composer.MailHeaderComposer;
import net.sf.amemailchecker.util.StringUtil;

public class RecipientHeaderComposer
extends BaseHeaderComposer
implements MailHeaderComposer {
    private int length;
    private int currentPos;
    private boolean headerSent;
    private String[] lines;
    private int currentLine;
    private StringBuffer buffer;
    private List<PostalAddressee> addressees;
    private String header;

    public RecipientHeaderComposer() {
    }

    public RecipientHeaderComposer(LetterImpl letterImpl, String string) {
        this.reuseFor(letterImpl, string);
    }

    public void reuseFor(PostalAddressee postalAddressee, String string) {
        if (this.currentPos != 0) {
            throw new IllegalStateException("Cannot be reused while active");
        }
        this.header = string;
        this.addressees = new ArrayList<PostalAddressee>();
        this.addressees.add(postalAddressee);
        this.length = 1;
    }

    public void reuseFor(LetterImpl letterImpl, String string) {
        if (this.currentPos != 0) {
            throw new IllegalStateException("Cannot be reused while active");
        }
        this.header = string;
        this.addressees = letterImpl.getRecipients(string);
        if (this.addressees != null) {
            this.length = this.addressees.size();
        }
    }

    @Override
    public synchronized String readNextToken() {
        String string;
        if (this.length <= 0 || this.addressees == null) {
            return null;
        }
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        if (!this.headerSent) {
            this.headerSent = true;
            this.buffer.append(this.header);
            this.buffer.append(": ");
        }
        if (this.currentPos == this.length && this.lines == null) {
            this.currentPos = 0;
            this.headerSent = false;
            this.clearLines();
            return null;
        }
        if (this.lines == null) {
            string = this.addressees.get(this.currentPos);
            if (this.currentPos > 0) {
                this.buffer.append("\t");
            }
            this.headerValueOf((PostalAddressee)string, this.buffer);
            if (this.currentPos < this.length - 1) {
                this.buffer.append(",");
            }
            ++this.currentPos;
            this.lines = this.buffer.toString().split("\n");
            this.buffer.delete(0, this.buffer.length());
        }
        return (string = this.nextLine()) != null ? string : this.readNextToken();
    }

    private String nextLine() {
        if (this.currentLine == this.lines.length) {
            this.clearLines();
            return null;
        }
        String string = this.lines[this.currentLine];
        ++this.currentLine;
        return string;
    }

    private void clearLines() {
        this.lines = null;
        this.currentLine = 0;
    }

    public void headerValueOf(PostalAddressee postalAddressee, StringBuffer stringBuffer) {
        String string = postalAddressee.getLabel();
        String string2 = postalAddressee.getAddress();
        boolean bl = StringUtil.containsNonAsciiChars((String)string);
        if (bl) {
            if ((string = this.getEncodedHeaderValue(string, "B")) != null && !string.equals("")) {
                stringBuffer.append(string);
            }
            stringBuffer.append("\n\t");
            stringBuffer.append(StringUtil.wrapIfNullAndEncapsulate((String)string2, (String)"<", (String)">"));
        } else {
            String string3 = StringUtil.wrapIfNullAndEncapsulate((String)string2, (String)"<", (String)">");
            if (string != null && !string.equals("")) {
                string3 = StringUtil.wrapIfNullAndEncapsulate((String)string, (String)"\"", (String)"\"") + " " + string3;
            }
            stringBuffer.append(string3);
        }
    }
}

