/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.parser.composer;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.mail.parser.CodecException;
import net.sf.amemailchecker.mail.parser.CodecUtil;
import net.sf.amemailchecker.mail.parser.composer.OutputTokenizer;
import net.sf.amemailchecker.util.StringUtil;

public class StreamOutputTokenizer
implements OutputTokenizer {
    private static final Logger logger = Logger.getLogger(StreamOutputTokenizer.class.getName());
    private InputStream input;
    private int limit;
    private byte[] buf;

    public void reuseFor(InputStream inputStream) {
        if (this.input != null && this.limit != -1) {
            throw new IllegalStateException("Cannot be reused while active");
        }
        this.input = inputStream;
        this.buf = new byte[57];
        this.limit = 0;
    }

    @Override
    public String readNextToken() {
        String string;
        if (this.limit == -1) {
            return null;
        }
        try {
            int n = this.input.available();
            if (n <= this.buf.length) {
                this.buf = new byte[n];
            }
            this.limit = this.input.read(this.buf);
            if (this.limit < 57) {
                this.limit = this.input.available();
            }
            if (this.limit == 0) {
                this.limit = -1;
                this.input.close();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        try {
            string = new String(CodecUtil.encodeBase64(this.buf));
        }
        catch (CodecException codecException) {
            logger.log(Level.SEVERE, codecException.getMessage(), codecException);
            string = new String(this.buf);
        }
        if (this.limit != -1 && string.endsWith("=")) {
            string = StringUtil.trimWith((String)string, (String)"", (String)"=");
        }
        return string;
    }
}

