/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.parser.composer;

import net.sf.amemailchecker.mail.parser.CodecUtil;
import net.sf.amemailchecker.mail.parser.composer.BaseHeaderComposer;
import net.sf.amemailchecker.mail.parser.composer.MailHeaderComposer;
import net.sf.amemailchecker.util.StringUtil;

public class StringHeaderComposer
extends BaseHeaderComposer
implements MailHeaderComposer {
    private String header;
    private String value;
    private int currentPos;
    private boolean containNonAscii;
    private int serviceSymLength;

    public void reuseFor(String string, String string2) {
        if (this.value != null && this.currentPos != string2.length()) {
            throw new IllegalStateException("Cannot be reused while active");
        }
        this.header = string;
        this.value = string2;
        this.currentPos = 0;
    }

    @Override
    public String readNextToken() {
        if (this.currentPos == this.value.length()) {
            this.value = null;
            return null;
        }
        String string = "";
        if (this.currentPos == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.header);
            stringBuffer.append(": ");
            if (StringUtil.containsNonAsciiChars((String)this.value)) {
                this.value = this.encodeHeaderValue(this.value, "B");
                this.containNonAscii = true;
                this.serviceSymLength = 6 + "B".length() + CodecUtil.getDefaultCharset().length();
            }
            this.currentPos = this.value.length();
            int n = this.header.length() + 2;
            if (this.containNonAscii) {
                n += this.serviceSymLength;
            }
            if (this.currentPos - n > 76) {
                this.currentPos = 76 - n;
                this.serviceSymLength += "\t".length();
            }
            string = this.nextLine(0, this.currentPos);
            stringBuffer.append(string);
            string = stringBuffer.toString();
            stringBuffer.delete(0, stringBuffer.length());
            return string;
        }
        int n = this.currentPos + 76;
        if (this.containNonAscii) {
            n -= this.serviceSymLength;
        }
        n = n > this.value.length() ? this.value.length() : n;
        string = "\t" + this.nextLine(this.currentPos, n);
        this.currentPos = n;
        return string;
    }

    private String nextLine(int n, int n2) {
        String string = this.value.substring(n, n2);
        if (this.containNonAscii) {
            string = this.getWrappedHeaderValue(string, "B");
        }
        return string;
    }
}

