/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.parser.mime;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.mail.MimeConstants;
import net.sf.amemailchecker.mail.impl.letter.RawMessagePart;
import net.sf.amemailchecker.mail.parser.reader.InputReader;
import net.sf.amemailchecker.util.StringUtil;

public class HeaderContentHandler {
    private static final Logger logger = Logger.getLogger(HeaderContentHandler.class.getName());
    private String currentHeader;

    public synchronized void flush() {
        this.currentHeader = null;
    }

    public Map<String, String> handleHeaders(InputReader inputReader, boolean bl) throws IOException {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while ((string = inputReader.readLine()) != null) {
            if (string.equals("")) {
                if (!bl) continue;
                break;
            }
            this.handleHeader(string, hashMap);
        }
        return hashMap;
    }

    public void handleHeader(String string, Map<String, String> map) {
        String string2;
        try {
            string2 = this.handleHeaderPrefix(string);
        }
        catch (IllegalStateException illegalStateException) {
            logger.log(Level.WARNING, illegalStateException.getMessage());
            return;
        }
        String string3 = this.handleHeaderValue(string, string2);
        Object object = MimeConstants.HEADERS;
        int n = ((String[])object).length;
        for (int i = 0; i < n; ++i) {
            String string4 = object[i];
            if (!string4.equalsIgnoreCase(string2)) continue;
            string2 = string4;
            break;
        }
        map.put(string2, (object = map.get(string2)) == null ? string3 : (String)object + string3);
    }

    public void handleMessageHeader(String string, String string2, RawMessagePart rawMessagePart) {
        if (string.equals("") && !rawMessagePart.getHeaders().containsKey(string2)) {
            return;
        }
        string = this.handleHeaderValue(string, string2);
        String string3 = rawMessagePart.getHeaders().get(string2);
        rawMessagePart.getHeaders().put(string2, string3 == null ? string : string3 + string);
    }

    public void handleMessageHeader(String string, RawMessagePart rawMessagePart) {
        String string2 = this.handleHeaderPrefix(string);
        this.handleMessageHeader(string, string2, rawMessagePart);
    }

    public String handleHeaderPrefix(String string) {
        String string2;
        boolean bl = this.isHeader(string);
        if (!bl && this.currentHeader == null) {
            throw new IllegalStateException("No current header exists in the cache and no header prefix was found in the input");
        }
        if (!bl) {
            return this.currentHeader;
        }
        int n = string.indexOf(58);
        this.currentHeader = string2 = n == -1 && this.currentHeader != null ? this.currentHeader : string.substring(0, n);
        return string2;
    }

    public String handleHeaderValue(String string, String string2) {
        if (StringUtil.startsWithIgnoreCase((String)string, (String)string2)) {
            string = string.length() > string2.length() + 2 ? string.substring(string2.length() + 2, string.length()) : StringUtil.trimWith((String)string, (String)"", (String)":");
        }
        string = StringUtil.trimWithDoubleQuote((String)string);
        return string;
    }

    public boolean isHeader(String string) {
        if (string.startsWith("\t")) {
            return false;
        }
        int n = string.indexOf(32);
        return n > 0 && string.substring(0, n).trim().endsWith(":");
    }
}

