/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.mail.parser.mime;

import java.io.IOException;
import net.sf.amemailchecker.mail.impl.letter.RawMessagePart;
import net.sf.amemailchecker.mail.parser.mime.HeaderContentHandler;
import net.sf.amemailchecker.mail.parser.mime.SimpleBodyContentHandler;
import net.sf.amemailchecker.mail.parser.reader.InputReader;

public class MimeMultipartBodyContentHandler
extends SimpleBodyContentHandler {
    HeaderContentHandler headerContentHandler = new HeaderContentHandler();

    boolean isBoundary(String string, String string2) {
        return string.contains(string2) && string.startsWith("--");
    }

    boolean isStartBoundary(String string, String string2) {
        return this.isBoundary(string, string2) && !string.endsWith("--");
    }

    boolean isEndBoundary(String string, String string2) {
        return this.isBoundary(string, string2) && string.endsWith("--");
    }

    @Override
    public void handle(InputReader inputReader, RawMessagePart rawMessagePart) throws IOException {
        String string;
        while ((string = inputReader.readLine()) != null) {
            this.handlePart(string, rawMessagePart, inputReader);
        }
    }

    void handlePart(String string, RawMessagePart rawMessagePart, InputReader inputReader) throws IOException {
        String string2 = rawMessagePart.getBoundary();
        if (this.isStartBoundary(string, string2)) {
            RawMessagePart rawMessagePart2 = new RawMessagePart();
            rawMessagePart2.setHeaders(this.headerContentHandler.handleHeaders(inputReader, true));
            rawMessagePart2.setRootBodyPart(rawMessagePart);
            rawMessagePart.getBodyParts().add(rawMessagePart2);
            if (rawMessagePart2.isMultipartBound()) {
                this.handle(inputReader, rawMessagePart2);
            } else {
                this.readPayload(inputReader, rawMessagePart2);
                this.handle(inputReader, rawMessagePart);
            }
        } else if (this.isEndBoundary(string, string2)) {
            if (rawMessagePart.getRootBodyPart() != null) {
                this.handle(inputReader, rawMessagePart.getRootBodyPart());
            } else {
                this.handle(inputReader, rawMessagePart);
            }
        }
    }

    @Override
    void readPayload(InputReader inputReader, RawMessagePart rawMessagePart) throws IOException {
        String string;
        while ((string = inputReader.readLine()) != null) {
            if (this.isBoundary(string, rawMessagePart.getRootBodyPart().getBoundary())) {
                this.handlePart(string, rawMessagePart.getRootBodyPart(), inputReader);
                break;
            }
            this.readPayloadLine(string, rawMessagePart);
        }
    }
}

