/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.proxy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.app.exception.ExceptionCode;
import net.sf.amemailchecker.app.model.ProxySettings;
import net.sf.amemailchecker.app.model.UserCredentials;
import net.sf.amemailchecker.mail.parser.CodecException;
import net.sf.amemailchecker.mail.parser.CodecUtil;
import net.sf.amemailchecker.proxy.ProxyDispatcher;
import net.sf.amemailchecker.proxy.exception.ProxyAuthenticationException;
import net.sf.amemailchecker.proxy.exception.ProxyNegotiationException;

public class ProxyConnector {
    private static Logger logger = Logger.getLogger(ProxyConnector.class.getName());

    public Socket establishProxyConnection(InetSocketAddress inetSocketAddress) throws IOException {
        Socket socket = new Socket();
        try {
            socket.connect(inetSocketAddress);
        }
        catch (IOException iOException) {
            throw new IOException("Can't connect to Proxy \n" + inetSocketAddress.getHostName() + ":" + inetSocketAddress.getPort() + "\n" + iOException.getMessage());
        }
        finally {
            if (!socket.isConnected()) {
                socket.close();
            }
        }
        logger.info("Successfully connected to proxy: [" + inetSocketAddress.getHostName() + ":" + inetSocketAddress.getPort() + "]");
        return socket;
    }

    public Socket connectHttp(Socket socket, String string, int n) throws IOException, ProxyAuthenticationException {
        String string2;
        Object object;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "iso-8859-1")));
        logger.info("Sending to HTTP proxy HTTP CONNECT method. Target host: [" + string + ":" + n + "]");
        ProxySettings proxySettings = ProxyDispatcher.getDispatcher().getProxySettings();
        String string3 = "CONNECT " + string + ":" + n + " HTTP/1.1";
        if (proxySettings.isUseAuthentication()) {
            object = proxySettings.getUserCredentials();
            string2 = ((UserCredentials)object).getUserName() + ":" + String.valueOf(((UserCredentials)object).getPassword());
            try {
                string2 = CodecUtil.encodeBase64(string2);
            }
            catch (CodecException codecException) {
                logger.log(Level.SEVERE, codecException.getMessage(), codecException);
                throw new IOException("Cannot perform proxy authentication.\nException in authentication negotiation.");
            }
            string3 = string3 + "\r\n";
            string3 = string3 + "Proxy-Authorization: Basic " + string2;
        }
        printWriter.write(string3 + "\r\n\r\n");
        printWriter.flush();
        object = bufferedReader.readLine();
        if (object == null) {
            throw new IOException("Unsuccessful negotiation with HTTP Proxy\nServer doesn't respond");
        }
        string2 = ((String)object).split(" ")[1];
        if (string2.equals("407")) {
            if (proxySettings.isUseAuthentication()) {
                throw new ProxyAuthenticationException((String)object, ExceptionCode.PROXY_AUTH_FAIL);
            }
            throw new ProxyAuthenticationException((String)object, ExceptionCode.PROXY_AUTH_REQ);
        }
        if (string2.equals("403")) {
            throw new ProxyNegotiationException((String)object, ExceptionCode.PROXY_ACCESS_FORB);
        }
        boolean bl = string2.equals("200");
        if (!bl) {
            throw new ProxyNegotiationException((String)object, ExceptionCode.PROXY_NEGOT_FAIL);
        }
        logger.info("HTTP CONNECT method is supported by proxy. Connection to target host: [" + string + ":" + n + "] established");
        return socket;
    }

    public Socket connectSocks(Socket socket, String string, int n) throws IOException {
        socket = new Socket(ProxyDispatcher.getDispatcher().getProxy());
        try {
            socket.connect(new InetSocketAddress(string, n));
        }
        catch (IOException iOException) {
            throw new IOException("Can't connect to Mail Server \n" + iOException.getLocalizedMessage());
        }
        finally {
            if (!socket.isConnected()) {
                socket.close();
            }
        }
        return socket;
    }
}

