/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.proxy;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import net.sf.amemailchecker.app.model.ProxySettings;
import net.sf.amemailchecker.mail.Protocol;
import net.sf.amemailchecker.proxy.ProxyAuthenticator;

public class ProxyDispatcher {
    private static ProxyDispatcher instance;
    private ProxySettings proxySettings;

    public static ProxyDispatcher getDispatcher() {
        if (instance == null) {
            instance = new ProxyDispatcher();
        }
        return instance;
    }

    public Proxy getProxy() {
        InetSocketAddress inetSocketAddress;
        if (this.proxySettings == null || !this.proxySettings.isUseProxy()) {
            return Proxy.NO_PROXY;
        }
        Proxy.Type type = this.proxySettings.isUseProxy() ? this.determineProxyType(this.proxySettings.getServerSettings().getProtocolType()) : Proxy.Type.DIRECT;
        InetSocketAddress inetSocketAddress2 = inetSocketAddress = this.proxySettings.isUseProxy() ? new InetSocketAddress(this.proxySettings.getServerSettings().getHost(), this.proxySettings.getServerSettings().getPort()) : null;
        if (this.proxySettings.isUseAuthentication()) {
            Authenticator.setDefault(new ProxyAuthenticator(this.proxySettings.getUserCredentials()));
        }
        return new Proxy(type, inetSocketAddress);
    }

    public Proxy.Type determineProxyType(int n) {
        Protocol protocol = Protocol.getById((int)n);
        return protocol.equals((Object)Protocol.SOCKS) ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }
}

