/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.UIManager;

public class ArrowIcon
implements Icon {
    private boolean descending;
    private int size;
    private Color color;

    public ArrowIcon(boolean bl, int n) {
        this.descending = bl;
        this.size = n;
        this.color = UIManager.getColor("controlText");
    }

    public ArrowIcon(boolean bl, int n, Color color) {
        this.descending = bl;
        this.size = n;
        this.color = color;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3 = this.size / 2;
        int n4 = this.descending ? n3 : -n3;
        n2 = n2 + 5 * this.size / 6 + (this.descending ? -n4 : 0);
        Color color = graphics.getColor();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.translate(n, n2);
        graphics2D.setColor(this.color);
        graphics2D.fillPolygon(new int[]{n3 / 2, n3, 0}, new int[]{n4, 0, 0}, 3);
        graphics2D.translate(-n, -n2);
        graphics.setColor(color);
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }
}

