/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.accordion;

import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarCellRenderer;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarInfo;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarModel;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarUI;
import net.sf.amemailchecker.gui.component.accordion.BasicAccordionBarUI;
import net.sf.amemailchecker.gui.component.accordion.DefaultAccordionBarModel;

public class AccordionBar
extends JComponent {
    private static final String uiClassID = "AccordionBarUI";
    protected AccordionBarModel model = new DefaultAccordionBarModel();
    protected AccordionBarCellRenderer cellRenderer;
    private EventListenerList headerListenerList = new EventListenerList();

    public AccordionBar() {
        this.updateUI();
    }

    public int locationToIndex(Point point) {
        return this.getUI().locationToIndex(point);
    }

    public AccordionBarModel getModel() {
        return this.model;
    }

    public void setModel(AccordionBarModel accordionBarModel) {
        AccordionBarModel accordionBarModel2 = this.model;
        this.model = accordionBarModel;
        this.firePropertyChange("model", accordionBarModel2, accordionBarModel);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((AccordionBarUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicAccordionBarUI());
        }
    }

    public void setUI(AccordionBarUI accordionBarUI) {
        super.setUI(accordionBarUI);
    }

    @Override
    public AccordionBarUI getUI() {
        return (AccordionBarUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public AccordionBarCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(AccordionBarCellRenderer accordionBarCellRenderer) {
        this.cellRenderer = accordionBarCellRenderer;
    }

    public synchronized void addHeaderActionListener(ActionListener actionListener) {
        this.headerListenerList.add(ActionListener.class, actionListener);
    }

    public synchronized void removeHeaderActionListener(ActionListener actionListener) {
        this.headerListenerList.remove(ActionListener.class, actionListener);
    }

    public ActionListener[] getHeaderActionListeners() {
        return (ActionListener[])this.headerListenerList.getListeners(ActionListener.class);
    }

    public synchronized void addHeaderMouseListener(MouseListener mouseListener) {
        this.headerListenerList.add(MouseListener.class, mouseListener);
    }

    public synchronized void removeHeaderMouseListener(MouseListener mouseListener) {
        this.headerListenerList.remove(MouseListener.class, mouseListener);
    }

    public MouseListener[] getHeaderMouseListeners() {
        return (MouseListener[])this.headerListenerList.getListeners(MouseListener.class);
    }

    public boolean empty() {
        return this.model.empty();
    }

    public void removeBar(int n) {
        this.model.removeBar(n);
    }

    public int indexOf(String string) {
        return this.model.indexOf(string);
    }

    public void removeBar(String string) {
        this.model.removeBar(string);
    }

    public void addBar(String string, String string2, Icon icon, JComponent jComponent) {
        this.model.addBar(string, string2, icon, jComponent);
    }

    public void addBar(String string, String string2, JComponent jComponent) {
        this.model.addBar(string, string2, jComponent);
    }

    public AccordionBarInfo getVisibleBarInfo() {
        return this.model.getVisibleBarInfo();
    }

    public void setVisibleBar(String string) {
        this.model.setVisibleBar(string);
    }

    public void setVisibleBar(int n) {
        this.model.setVisibleBar(n);
    }

    public int getVisibleBarIndex() {
        return this.model.getVisibleBarIndex();
    }

    public boolean isVisibleBar(int n) {
        return this.model.isVisibleBar(n);
    }

    public boolean containsBar(String string) {
        return this.model.containsBar(string);
    }

    public int count() {
        return this.model.count();
    }

    public List<AccordionBarInfo> values() {
        return this.model.values();
    }

    public void updateBar(String string, String string2) {
        this.model.updateBar(string, string2);
    }

    public void updateBar(int n, String string) {
        this.model.updateBar(n, string);
    }

    public boolean isVisibleBar(String string) {
        return this.model.isVisibleBar(string);
    }

    public AccordionBarInfo getBarInfo(String string) {
        return this.model.getBarInfo(string);
    }
}

