/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.accordion;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import net.sf.amemailchecker.gui.component.accordion.AccordionBar;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarCellRenderer;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarInfo;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarModel;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarModelChangeListener;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarUI;
import net.sf.amemailchecker.gui.component.accordion.DefaultAccordionBarCellRenderer;

public class BasicAccordionBarUI
extends AccordionBarUI {
    private static final int DEFAULT_BAR_HEADER_HEIGHT = 30;
    private CellRendererPane rendererPane;
    private ChangeListener changeListener;
    private AccordionBarModelChangeListener modelChangeListener;
    private MouseAdapter headerMouseListener;
    private PropertyChangeListener propertyChangeListener;
    private int highlightedIndex = -1;
    protected AccordionBar accordionBar;
    private JComponent visibleComponent;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicAccordionBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.accordionBar = (AccordionBar)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
    }

    public void installComponents() {
        this.rendererPane = new CellRendererPane();
        this.accordionBar.add(this.rendererPane);
        this.accordionBar.setCellRenderer(new DefaultAccordionBarCellRenderer());
    }

    public void uninstallComponents() {
        this.accordionBar.removeAll();
        this.rendererPane.removeAll();
        this.rendererPane = null;
        this.visibleComponent = null;
    }

    public void installListeners() {
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("model")) {
                    BasicAccordionBarUI.this.installModelListeners();
                    BasicAccordionBarUI.this.installMouseListeners();
                }
            }
        };
        this.headerMouseListener = new HeaderMouseListener();
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BasicAccordionBarUI.this.accordionBar.repaint();
            }
        };
        this.modelChangeListener = new AccordionBarModelChangeListener(){

            @Override
            public void barAdded(ChangeEvent changeEvent) {
                if (BasicAccordionBarUI.this.accordionBar.getModel().count() == 1) {
                    BasicAccordionBarUI.this.installMouseListeners();
                }
            }

            @Override
            public void barRemoved(ChangeEvent changeEvent) {
                if (BasicAccordionBarUI.this.accordionBar.getModel().empty()) {
                    BasicAccordionBarUI.this.uninstallMouseListeners();
                }
            }

            @Override
            public void barSelected(ChangeEvent changeEvent) {
            }
        };
        this.accordionBar.addPropertyChangeListener(this.propertyChangeListener);
        this.installMouseListeners();
        this.installModelListeners();
    }

    private void installMouseListeners() {
        boolean bl = false;
        for (MouseListener mouseListener : this.accordionBar.getMouseListeners()) {
            if (!mouseListener.equals(this.headerMouseListener)) continue;
            bl = true;
            break;
        }
        if (!bl && !this.accordionBar.getModel().empty()) {
            this.accordionBar.addMouseListener(this.headerMouseListener);
            this.accordionBar.addMouseMotionListener(this.headerMouseListener);
        }
    }

    private void uninstallMouseListeners() {
        this.accordionBar.removeMouseListener(this.headerMouseListener);
        this.accordionBar.removeMouseMotionListener(this.headerMouseListener);
    }

    private void installModelListeners() {
        this.accordionBar.getModel().addModelChangeListener(this.modelChangeListener);
        this.accordionBar.getModel().addChangeListener(this.changeListener);
    }

    public void uninstallListeners() {
        this.uninstallMouseListeners();
        this.accordionBar.removePropertyChangeListener(this.propertyChangeListener);
        this.accordionBar.getModel().removeChangeListener(this.changeListener);
        this.accordionBar.getModel().removeModelChangeListener(this.modelChangeListener);
        this.changeListener = null;
        this.headerMouseListener = null;
        this.modelChangeListener = null;
        this.propertyChangeListener = null;
    }

    public void installDefaults() {
    }

    public void uninstallDefaults() {
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        this.paintBars(graphics);
    }

    protected void paintBars(Graphics graphics) {
        AccordionBarCellRenderer accordionBarCellRenderer = this.accordionBar.getCellRenderer();
        AccordionBarModel accordionBarModel = this.accordionBar.getModel();
        List<AccordionBarInfo> list = this.accordionBar.getModel().values();
        int n = 0;
        int n2 = list.size();
        if (n2 == 0 && this.visibleComponent != null) {
            this.accordionBar.remove(this.visibleComponent);
            this.visibleComponent = null;
        }
        for (int i = 0; i < n2; ++i) {
            AccordionBarInfo accordionBarInfo = list.get(i);
            boolean bl = accordionBarModel.isVisibleBar(i);
            JComponent jComponent = accordionBarCellRenderer.getCellRendererComponent(this.accordionBar, accordionBarInfo, i, accordionBarModel.isVisibleBar(i));
            jComponent.setFocusable(i != -1 && i == this.highlightedIndex && !bl);
            jComponent.updateUI();
            this.rendererPane.paintComponent(graphics, jComponent, this.accordionBar, 0, n, this.accordionBar.getWidth(), 30, true);
            n += 30;
            if (!bl) continue;
            graphics.translate(0, n);
            JComponent jComponent2 = accordionBarModel.values().get(i).getComponent();
            if (this.visibleComponent != null) {
                this.accordionBar.remove(this.visibleComponent);
            }
            this.accordionBar.add(jComponent2);
            this.visibleComponent = jComponent2;
            int n3 = this.accordionBar.getWidth();
            int n4 = this.accordionBar.getHeight() - n2 * 30;
            jComponent2.setSize(new Dimension(n3, n4));
            jComponent2.setLocation(0, n);
            jComponent2.updateUI();
            int n5 = n;
            n += jComponent2.getHeight() - n5;
            graphics.translate(0, 0);
        }
        this.rendererPane.removeAll();
    }

    @Override
    public int locationToIndex(Point point) {
        int n = (int)point.getY();
        AccordionBarModel accordionBarModel = this.accordionBar.getModel();
        int n2 = accordionBarModel.getVisibleBarIndex();
        AccordionBarInfo accordionBarInfo = accordionBarModel.getVisibleBarInfo();
        int n3 = accordionBarInfo.getComponent().getHeight();
        int n4 = n2 * 30;
        if (n <= n4) {
            return n / 30;
        }
        if (n > n4 && n < n4 + n3) {
            return n2;
        }
        return (n - n3) / 30;
    }

    private class HeaderMouseListener
    extends MouseAdapter {
        private HeaderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.isHeaderBar(mouseEvent.getPoint())) {
                return;
            }
            for (MouseListener mouseListener : BasicAccordionBarUI.this.accordionBar.getHeaderMouseListeners()) {
                mouseListener.mouseClicked(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.isHeaderBar(mouseEvent.getPoint())) {
                return;
            }
            for (MouseListener mouseListener : BasicAccordionBarUI.this.accordionBar.getHeaderMouseListeners()) {
                mouseListener.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.isHeaderBar(mouseEvent.getPoint())) {
                return;
            }
            for (MouseListener mouseListener : BasicAccordionBarUI.this.accordionBar.getHeaderMouseListeners()) {
                mouseListener.mouseEntered(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (!this.isHeaderBar(mouseEvent.getPoint())) {
                return;
            }
            AccordionBarModel accordionBarModel = BasicAccordionBarUI.this.accordionBar.getModel();
            int n2 = accordionBarModel.getVisibleBarIndex();
            if (n2 != (n = this.locationToIndex(mouseEvent.getPoint())) && mouseEvent.getButton() == 1) {
                accordionBarModel.setVisibleBar(n);
                for (EventListener eventListener : BasicAccordionBarUI.this.accordionBar.getHeaderActionListeners()) {
                    eventListener.actionPerformed(new ActionEvent(mouseEvent.getComponent(), 1001, "", mouseEvent.getWhen(), mouseEvent.getModifiers()));
                }
            }
            for (EventListener eventListener : BasicAccordionBarUI.this.accordionBar.getHeaderMouseListeners()) {
                eventListener.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n;
            if (!this.isHeaderBar(mouseEvent.getPoint())) {
                BasicAccordionBarUI.this.highlightedIndex = -1;
                BasicAccordionBarUI.this.accordionBar.repaint();
                return;
            }
            AccordionBarModel accordionBarModel = BasicAccordionBarUI.this.accordionBar.getModel();
            if (accordionBarModel.isVisibleBar(n = this.locationToIndex(mouseEvent.getPoint()))) {
                BasicAccordionBarUI.this.highlightedIndex = -1;
                BasicAccordionBarUI.this.accordionBar.repaint();
                return;
            }
            if (n != BasicAccordionBarUI.this.highlightedIndex) {
                BasicAccordionBarUI.this.highlightedIndex = n;
            }
            BasicAccordionBarUI.this.accordionBar.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            BasicAccordionBarUI.this.highlightedIndex = -1;
            BasicAccordionBarUI.this.accordionBar.repaint();
            if (!this.isHeaderBar(mouseEvent.getPoint())) {
                return;
            }
            for (MouseListener mouseListener : BasicAccordionBarUI.this.accordionBar.getHeaderMouseListeners()) {
                mouseListener.mouseExited(mouseEvent);
            }
        }

        private boolean isHeaderBar(Point point) {
            Component component = BasicAccordionBarUI.this.accordionBar.findComponentAt(point);
            if (component == null || component.equals(BasicAccordionBarUI.this.visibleComponent)) {
                return false;
            }
            for (Component component2 : BasicAccordionBarUI.this.visibleComponent.getComponents()) {
                if (!component2.equals(component)) continue;
                return false;
            }
            return true;
        }

        private int locationToIndex(Point point) {
            int n = point.y;
            int n2 = (BasicAccordionBarUI.this.accordionBar.getModel().getVisibleBarIndex() + 1) * 30;
            return n > n2 ? (n - BasicAccordionBarUI.this.visibleComponent.getHeight()) / 30 : n / 30;
        }
    }
}

