/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.accordion;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.text.AttributedString;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import net.sf.amemailchecker.gui.component.accordion.AccordionHeader;
import net.sf.amemailchecker.gui.component.accordion.AccordionHeaderUI;

public class BasicAccordionHeaderUI
extends AccordionHeaderUI {
    private Color highlightBorderColor;
    private Border border;
    protected AccordionHeader accordionHeader;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicAccordionHeaderUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.accordionHeader = (AccordionHeader)jComponent;
        this.installDefaults();
        this.installComponents();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.accordionHeader = null;
    }

    public void installDefaults() {
        this.border = BorderFactory.createEtchedBorder();
        this.highlightBorderColor = new Color(188, 210, 230);
    }

    public void uninstallDefaults() {
        this.accordionHeader.setBorder(null);
        this.highlightBorderColor = null;
    }

    public void installComponents() {
        this.accordionHeader.setBorder(this.border);
    }

    public void uninstallComponents() {
        this.accordionHeader.setBorder(null);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        Paint paint = graphics2D.getPaint();
        boolean bl = jComponent.getBorder() != null;
        int n = bl ? jComponent.getBorder().getBorderInsets((Component)jComponent).left : 0;
        int n2 = bl ? jComponent.getBorder().getBorderInsets((Component)jComponent).top : 0;
        int n3 = bl ? jComponent.getHeight() - n2 * 2 : jComponent.getHeight();
        int n4 = bl ? jComponent.getWidth() - n * 2 : jComponent.getWidth();
        Point2D.Float float_ = new Point2D.Float(n, n2);
        Point2D.Float float_2 = new Point2D.Float(n, n3);
        Color color = jComponent.getParent().getBackground();
        graphics2D.setColor(color);
        if (!this.accordionHeader.isActive()) {
            object = new float[]{0.0f, 0.3f, 0.7f, 1.0f};
            Color[] colorArray = new Color[]{Color.WHITE, color, color, Color.WHITE};
            graphics2D.setPaint(new LinearGradientPaint(float_, float_2, (float[])object, colorArray));
        }
        graphics2D.fillRect(n, n2, n4, n3);
        graphics2D.setPaint(paint);
        if (this.accordionHeader.isFocusable()) {
            this.accordionHeader.setBorder(null);
            object = new Rectangle(n, n2, n4 - 1, n3 - 1);
            this.paintFocusBorder(graphics2D, 1, (Shape)object, this.highlightBorderColor);
        }
        this.paintText(graphics2D, jComponent);
        super.paint(graphics, jComponent);
    }

    private void paintFocusBorder(Graphics2D graphics2D, int n, Shape shape, Color color) {
        int n2;
        graphics2D.setColor(color);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = n2 = n * 2; i >= 2; i -= 2) {
            graphics2D.setStroke(new BasicStroke(i));
            graphics2D.draw(shape);
        }
    }

    protected void paintText(Graphics2D graphics2D, JComponent jComponent) {
        String string = this.accordionHeader.getText();
        graphics2D.setColor(this.accordionHeader.isActive() ? Color.LIGHT_GRAY : Color.BLACK);
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        int n = graphics2D.getFontMetrics().stringWidth(string);
        int n2 = (int)graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getHeight();
        graphics2D.drawString(attributedString.getIterator(), jComponent.getWidth() / 2 - n / 2, jComponent.getHeight() / 2 + n2 / 4);
    }
}

