/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.accordion;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarInfo;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarModel;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarModelChangeListener;
import net.sf.amemailchecker.gui.component.accordion.DefaultAccordionBarInfo;

public class DefaultAccordionBarModel
implements AccordionBarModel {
    private List<AccordionBarInfo> bars = new LinkedList<AccordionBarInfo>();
    private int visibleBarIndex;
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public void addBar(String string, String string2, JComponent jComponent) {
        this.addBar(new DefaultAccordionBarInfo(string, string2, jComponent));
    }

    @Override
    public void addBar(String string, String string2, Icon icon, JComponent jComponent) {
        this.addBar(new DefaultAccordionBarInfo(string, string2, icon, jComponent));
    }

    private synchronized void addBar(AccordionBarInfo accordionBarInfo) {
        this.bars.add(accordionBarInfo);
        if (this.bars.size() == 1) {
            this.setVisibleBar(0);
        }
        this.fireStateChanged();
        this.fireStateChanged(AccordionBarModel.EventType.BAR_ADDED);
    }

    @Override
    public boolean containsBar(String string) {
        return this.indexOf(string) != -1;
    }

    @Override
    public void updateBar(String string, String string2) {
        int n = this.indexOf(string);
        this.updateBar(n, string2);
    }

    @Override
    public void updateBar(int n, String string) {
        if (n == -1) {
            return;
        }
        ((DefaultAccordionBarInfo)this.bars.get(n)).setTitle(string);
        this.fireStateChanged();
    }

    @Override
    public synchronized void removeBar(String string) {
        this.removeBar(this.indexOf(string));
    }

    @Override
    public synchronized void removeBar(int n) {
        if (n == -1) {
            return;
        }
        this.bars.remove(n);
        if (n == this.visibleBarIndex && this.count() > 0) {
            this.setVisibleBar(this.visibleBarIndex > 0 ? (this.visibleBarIndex = this.visibleBarIndex - 1) : 0);
        }
        this.fireStateChanged();
        this.fireStateChanged(AccordionBarModel.EventType.BAR_REMOVED);
    }

    @Override
    public synchronized int indexOf(String string) {
        int n = 0;
        boolean bl = false;
        for (AccordionBarInfo accordionBarInfo : this.bars) {
            if (accordionBarInfo.getName().equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl ? n : -1;
    }

    @Override
    public AccordionBarInfo getVisibleBarInfo() {
        return this.bars.get(this.visibleBarIndex);
    }

    @Override
    public int getVisibleBarIndex() {
        return this.visibleBarIndex;
    }

    @Override
    public boolean isVisibleBar(String string) {
        return this.indexOf(string) == this.visibleBarIndex;
    }

    @Override
    public boolean isVisibleBar(int n) {
        return n == this.visibleBarIndex;
    }

    @Override
    public void setVisibleBar(String string) {
        int n = this.indexOf(string);
        if (n == -1) {
            throw new IllegalArgumentException("No Bar with passed name [ " + string + " ]");
        }
        this.setVisibleBar(n);
    }

    @Override
    public void setVisibleBar(int n) {
        this.visibleBarIndex = n;
        this.fireStateChanged();
        this.fireStateChanged(AccordionBarModel.EventType.BAR_SELECTED);
    }

    @Override
    public AccordionBarInfo getBarInfo(String string) {
        return this.bars.get(this.indexOf(string));
    }

    @Override
    public int count() {
        return this.bars.size();
    }

    @Override
    public boolean empty() {
        return this.count() <= 0;
    }

    @Override
    public List<AccordionBarInfo> values() {
        return Collections.unmodifiableList(this.bars);
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    @Override
    public void addModelChangeListener(AccordionBarModelChangeListener accordionBarModelChangeListener) {
        this.listenerList.add(AccordionBarModelChangeListener.class, accordionBarModelChangeListener);
    }

    @Override
    public void removeModelChangeListener(AccordionBarModelChangeListener accordionBarModelChangeListener) {
        this.listenerList.remove(AccordionBarModelChangeListener.class, accordionBarModelChangeListener);
    }

    protected void fireStateChanged(AccordionBarModel.EventType eventType) {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.listenerList.getListenerList();
        block5: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != AccordionBarModelChangeListener.class) continue;
            AccordionBarModelChangeListener accordionBarModelChangeListener = (AccordionBarModelChangeListener)objectArray[i + 1];
            switch (eventType) {
                case BAR_ADDED: {
                    accordionBarModelChangeListener.barAdded(changeEvent);
                    continue block5;
                }
                case BAR_REMOVED: {
                    accordionBarModelChangeListener.barRemoved(changeEvent);
                    continue block5;
                }
                case BAR_SELECTED: {
                    accordionBarModelChangeListener.barSelected(changeEvent);
                }
            }
        }
    }

    public AccordionBarModelChangeListener[] getModelChangeListeners() {
        return (AccordionBarModelChangeListener[])this.listenerList.getListeners(AccordionBarModelChangeListener.class);
    }
}

