/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.button;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import net.sf.amemailchecker.gui.component.button.CrossHeaderButton;
import net.sf.amemailchecker.gui.component.button.CrossHeaderButtonUI;

public class BasicCrossHeaderButtonUI
extends CrossHeaderButtonUI {
    private CrossHeaderButton button;
    private MouseAdapter buttonMouseListener;
    private Color highlightColor = new Color(188, 210, 230);
    private Border highlightBorder = new EtchedBorder(0);

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicCrossHeaderButtonUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.button = (CrossHeaderButton)jComponent;
        this.installDefaults();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.button = null;
    }

    public void installListeners() {
        super.installListeners(this.button);
        this.buttonMouseListener = new CrossHeaderButtonMouseListener();
        this.button.addMouseListener(this.buttonMouseListener);
        this.button.addMouseMotionListener(this.buttonMouseListener);
        this.button.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BasicCrossHeaderButtonUI.this.button.repaint();
            }
        });
    }

    public void uninstallListeners() {
        super.uninstallListeners(this.button);
        this.button.removeMouseListener(this.buttonMouseListener);
        this.button.removeMouseMotionListener(this.buttonMouseListener);
        this.buttonMouseListener = null;
    }

    public void installDefaults() {
        super.installDefaults(this.button);
        this.button.setContentAreaFilled(false);
        this.button.setFocusable(false);
        this.button.setBorder(this.highlightBorder);
        this.button.setBorderPainted(false);
        this.button.setRolloverEnabled(true);
    }

    public void uninstallDefaults() {
        super.uninstallDefaults(this.button);
        this.button.setBorder(null);
        this.highlightBorder = null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        ButtonModel buttonModel = this.button.getModel();
        if (buttonModel.isPressed()) {
            graphics2D.translate(1, 1);
        }
        graphics2D.setColor(buttonModel.isRollover() ? this.highlightColor : Color.BLACK);
        this.painCross(graphics2D, jComponent);
        super.paint(graphics, jComponent);
    }

    protected void painCross(Graphics2D graphics2D, JComponent jComponent) {
        graphics2D.setStroke(new BasicStroke(2.0f));
        int n = 6;
        graphics2D.drawLine(n, n, jComponent.getWidth() - n - 1, jComponent.getHeight() - n - 1);
        graphics2D.drawLine(jComponent.getWidth() - n - 1, n, n, jComponent.getHeight() - n - 1);
    }

    private class CrossHeaderButtonMouseListener
    extends MouseAdapter {
        private CrossHeaderButtonMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ActionEvent actionEvent = new ActionEvent(mouseEvent.getComponent(), 1001, "", mouseEvent.getWhen(), mouseEvent.getModifiers());
            for (ActionListener actionListener : BasicCrossHeaderButtonUI.this.button.getActionListeners()) {
                actionListener.actionPerformed(actionEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            ((AbstractButton)mouseEvent.getComponent()).setBorderPainted(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ((AbstractButton)mouseEvent.getComponent()).setBorderPainted(false);
        }
    }
}

