/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.button;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import net.sf.amemailchecker.gui.component.button.DropDownMenuButton;
import net.sf.amemailchecker.gui.component.button.DropDownMenuButtonModel;
import net.sf.amemailchecker.gui.component.button.DropDownMenuButtonUI;
import net.sf.amemailchecker.gui.component.button.DropDownMenuListener;

public class BasicDropDownMenuButtonUI
extends DropDownMenuButtonUI {
    public static final int EXT_AREA_WIDTH = 20;
    protected Color highlightColor;
    protected Color disabledTextColor;
    protected Color pressedTextColor;
    protected Border highlightBorder;
    protected DropDownMenuButton button;
    protected DropDownMenuButtonModel model;
    private ChangeListener modelChangeListener;
    private ActionListener dropDownMenuActionListener;
    private PropertyChangeListener propertyChangeListener;
    private PopupMenuListener dropDownMenuListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDropDownMenuButtonUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.button = (DropDownMenuButton)jComponent;
        this.model = this.button.getModel();
        this.installDefaults();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.model = null;
        this.button = null;
    }

    public void installDefaults() {
        this.highlightColor = new Color(188, 210, 230);
        this.disabledTextColor = Color.GRAY;
        this.pressedTextColor = this.highlightColor;
        this.highlightBorder = BorderFactory.createLineBorder(this.highlightColor, 3);
    }

    public void uninstallDefaults() {
        this.highlightColor = null;
        this.disabledTextColor = null;
        this.highlightBorder = null;
    }

    public void installListeners() {
        this.modelChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BasicDropDownMenuButtonUI.this.button.repaint();
            }
        };
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("model")) {
                    BasicDropDownMenuButtonUI.this.model = (DropDownMenuButtonModel)propertyChangeEvent.getNewValue();
                }
                BasicDropDownMenuButtonUI.this.button.repaint();
            }
        };
        this.dropDownMenuActionListener = new DropDownMenuActionListener();
        this.dropDownMenuListener = new DropDownMenuListener(this.button, this.model);
        this.button.getModel().addChangeListener(this.modelChangeListener);
        this.button.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallListeners() {
        this.button.getModel().removeChangeListener(this.modelChangeListener);
        this.button.removePropertyChangeListener(this.propertyChangeListener);
        this.modelChangeListener = null;
        this.dropDownMenuActionListener = null;
        this.propertyChangeListener = null;
        this.dropDownMenuListener = null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
        graphics2D.setColor(this.highlightColor);
        graphics2D.draw(rectangle);
        if (this.model.isUseExtSeparately()) {
            graphics2D.drawLine(jComponent.getWidth() - 20, 0, jComponent.getWidth() - 20, jComponent.getHeight());
        }
        graphics2D.setColor(Color.GRAY);
        Rectangle rectangle2 = new Rectangle(jComponent.getWidth() - 20 + 1, 1, 18, jComponent.getHeight() - 2);
        Rectangle rectangle3 = new Rectangle(1, 1, jComponent.getWidth() - 20 - 2, jComponent.getHeight() - 2);
        Rectangle rectangle4 = new Rectangle(1, 1, jComponent.getWidth() - 2, jComponent.getHeight() - 2);
        if (this.model.isUseExtSeparately()) {
            this.paintBody(graphics2D, rectangle3, this.model.isPressed() || this.model.isPressPerformed(), this.model.isEnabled());
            this.paintBody(graphics2D, rectangle2, this.model.isExtPressed(), this.model.isEnabled());
            if (this.model.isExtRollover()) {
                this.highlightBorder.paintBorder(jComponent, graphics2D, rectangle2.x - 1, rectangle2.y, rectangle2.width + 1, rectangle2.height);
            }
        } else {
            this.paintBody(graphics2D, rectangle4, this.model.isPressPerformed(), this.model.isEnabled());
            if (this.model.isRollover()) {
                this.highlightBorder.paintBorder(jComponent, graphics2D, rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
            }
        }
        this.paintTriangle(graphics2D, jComponent);
        this.button.setForeground(this.currentDecorationColor());
        super.paint(graphics, jComponent);
    }

    protected void paintTriangle(Graphics2D graphics2D, JComponent jComponent) {
        int n = jComponent.getWidth() - 16;
        int n2 = jComponent.getHeight() / 4;
        Polygon polygon = new Polygon(new int[]{n, n + 6, n + 12}, new int[]{n2 + 6, n2 + 12, n2 + 6}, 3);
        graphics2D.setColor(!this.model.isExtPressed() && this.model.isPressed() ? Color.BLACK : this.currentDecorationColor());
        graphics2D.fillPolygon(polygon);
    }

    protected void paintBody(Graphics2D graphics2D, Rectangle rectangle, boolean bl, boolean bl2) {
        Point2D.Float float_ = new Point2D.Float(rectangle.x, rectangle.y);
        Point2D.Float float_2 = new Point2D.Float(rectangle.x, rectangle.height);
        Color color = bl || !bl2 ? this.button.getBackground() : this.highlightColor;
        graphics2D.draw(rectangle);
        Paint paint = graphics2D.getPaint();
        float[] fArray = new float[]{0.0f, 0.3f, 0.7f, 1.0f};
        Color[] colorArray = new Color[]{Color.WHITE, color, color, Color.WHITE};
        graphics2D.setPaint(new LinearGradientPaint(float_, float_2, fArray, colorArray));
        graphics2D.fill(rectangle);
        graphics2D.setPaint(paint);
    }

    private Color currentDecorationColor() {
        boolean bl = this.model.isEnabled();
        if (!bl) {
            return this.disabledTextColor;
        }
        Color color = this.model.isRollover() ? Color.BLACK.brighter() : Color.BLACK;
        color = (this.model.isPressed() || this.model.isPressPerformed()) && bl ? this.pressedTextColor : color;
        return color;
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new ExtendedAreaCheckerMouseListener(abstractButton);
    }

    private class DropDownMenuActionListener
    implements ActionListener {
        private DropDownMenuActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BasicDropDownMenuButtonUI.this.model.isPressPerformed()) {
                if (!BasicDropDownMenuButtonUI.this.model.isExtPressed() && BasicDropDownMenuButtonUI.this.model.isUseExtSeparately()) {
                    return;
                }
                JPopupMenu jPopupMenu = BasicDropDownMenuButtonUI.this.button.getPopupMenu();
                if (jPopupMenu == null) {
                    return;
                }
                BasicDropDownMenuButtonUI.this.model.press();
                jPopupMenu.addPopupMenuListener(BasicDropDownMenuButtonUI.this.dropDownMenuListener);
                for (MenuElement menuElement : jPopupMenu.getSubElements()) {
                    Action action = ((JMenuItem)menuElement).getAction();
                    if (action == null) continue;
                    ((JMenuItem)menuElement).setEnabled(action.isEnabled());
                }
                jPopupMenu.show(BasicDropDownMenuButtonUI.this.button, 0, BasicDropDownMenuButtonUI.this.button.getHeight());
            } else {
                BasicDropDownMenuButtonUI.this.model.release();
            }
        }
    }

    private class ExtendedAreaCheckerMouseListener
    extends BasicButtonListener {
        public ExtendedAreaCheckerMouseListener(AbstractButton abstractButton) {
            super(abstractButton);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (!BasicDropDownMenuButtonUI.this.button.getModel().isEnabled()) {
                return;
            }
            boolean bl = this.checkIsInExtendedArea(mouseEvent.getPoint());
            BasicDropDownMenuButtonUI.this.model.setExtPressed(bl);
            BasicDropDownMenuButtonUI.this.model.setPressed(BasicDropDownMenuButtonUI.this.model.isUseExtSeparately() && !bl || bl);
            BasicDropDownMenuButtonUI.this.model.setRollover(false);
            BasicDropDownMenuButtonUI.this.model.setExtRollover(false);
            ActionEvent actionEvent = new ActionEvent(mouseEvent.getComponent(), 1001, "", mouseEvent.getWhen(), mouseEvent.getModifiers());
            BasicDropDownMenuButtonUI.this.dropDownMenuActionListener.actionPerformed(actionEvent);
            if (BasicDropDownMenuButtonUI.this.model.isUseExtSeparately() && !bl) {
                for (ActionListener actionListener : BasicDropDownMenuButtonUI.this.button.getActionListeners()) {
                    actionListener.actionPerformed(actionEvent);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            BasicDropDownMenuButtonUI.this.model.setPressed(false);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            BasicDropDownMenuButtonUI.this.model.setRollover(false);
            BasicDropDownMenuButtonUI.this.model.setExtRollover(false);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            boolean bl = this.checkIsInExtendedArea(mouseEvent.getPoint());
            BasicDropDownMenuButtonUI.this.model.setExtRollover(bl);
            BasicDropDownMenuButtonUI.this.model.setRollover(!BasicDropDownMenuButtonUI.this.model.isUseExtSeparately() || !bl);
        }

        private boolean checkIsInExtendedArea(Point point) {
            return point.getLocation().getX() > (double)(BasicDropDownMenuButtonUI.this.button.getWidth() - 20);
        }
    }
}

