/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.button;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import net.sf.amemailchecker.gui.component.button.BasicDropDownMenuButtonUI;
import net.sf.amemailchecker.gui.component.button.DefaultDropDownMenuButtonModel;
import net.sf.amemailchecker.gui.component.button.DropDownMenuButtonModel;
import net.sf.amemailchecker.gui.component.button.DropDownMenuButtonUI;

public class DropDownMenuButton
extends AbstractButton {
    public static final String uiClassID = "DropDownMenuButtonUI";
    private JPopupMenu popupMenu;
    private DropDownMenuButtonModel model = new DefaultDropDownMenuButtonModel();
    private EventListenerList actionListenerList = new EventListenerList();

    public DropDownMenuButton(boolean bl) {
        this();
        this.model.setUseExtSeparately(bl);
        this.updateUI();
    }

    public DropDownMenuButton() {
        this.popupMenu = new JPopupMenu();
        this.updateUI();
    }

    public DropDownMenuButton(String string) {
        this(string, false);
    }

    public DropDownMenuButton(String string, boolean bl) {
        this(bl);
        this.setText(string);
        this.updateUI();
    }

    @Override
    public DropDownMenuButtonModel getModel() {
        return this.model;
    }

    public void setModel(DropDownMenuButtonModel dropDownMenuButtonModel) {
        DropDownMenuButtonModel dropDownMenuButtonModel2 = this.model;
        this.model = dropDownMenuButtonModel;
        super.setModel(dropDownMenuButtonModel);
        this.firePropertyChange("model", dropDownMenuButtonModel2, dropDownMenuButtonModel);
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top, insets.left, insets.bottom, insets.right + 20);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((DropDownMenuButtonUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicDropDownMenuButtonUI());
        }
    }

    public void setUI(DropDownMenuButtonUI dropDownMenuButtonUI) {
        super.setUI(dropDownMenuButtonUI);
    }

    @Override
    public DropDownMenuButtonUI getUI() {
        return (DropDownMenuButtonUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.model.setEnabled(bl);
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        JPopupMenu jPopupMenu2 = this.popupMenu;
        this.popupMenu = jPopupMenu;
        this.firePropertyChange("popupMenu", jPopupMenu2, jPopupMenu);
    }

    @Override
    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListenerList.add(ActionListener.class, new ActionListenerWrapper(actionListener));
    }

    @Override
    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListenerList.remove(ActionListener.class, actionListener);
    }

    @Override
    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.actionListenerList.getListeners(ActionListener.class);
    }

    public void addMenuAction(Action action) {
        this.popupMenu.add(new JMenuItem(action));
    }

    private class ActionListenerWrapper
    implements ActionListener {
        private ActionListener actionListener;

        private ActionListenerWrapper(ActionListener actionListener) {
            this.actionListener = actionListener;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DropDownMenuButton.this.model.isExtPressed() && DropDownMenuButton.this.model.isUseExtSeparately() && !DropDownMenuButton.this.model.isPressPerformed()) {
                this.actionListener.actionPerformed(actionEvent);
            }
        }
    }
}

