/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.button;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.sf.amemailchecker.gui.component.button.DropDownMenuActionModel;

public class DropDownMenuListener
implements PopupMenuListener {
    private Dimension size;
    private JComponent component;
    private DropDownMenuActionModel model;
    private boolean adjustSize;

    public DropDownMenuListener(JComponent jComponent, DropDownMenuActionModel dropDownMenuActionModel) {
        this.component = jComponent;
        this.model = dropDownMenuActionModel;
        this.adjustSize = true;
    }

    public DropDownMenuListener(boolean bl, DropDownMenuActionModel dropDownMenuActionModel, JComponent jComponent) {
        this.adjustSize = bl;
        this.model = dropDownMenuActionModel;
        this.component = jComponent;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
        this.size = jPopupMenu.getPreferredSize();
        if (this.adjustSize && jPopupMenu.getPreferredSize().getWidth() < (double)this.component.getWidth()) {
            jPopupMenu.setPreferredSize(new Dimension(this.component.getWidth(), jPopupMenu.getPreferredSize().height));
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.release(popupMenuEvent);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.release(popupMenuEvent);
    }

    private void release(PopupMenuEvent popupMenuEvent) {
        this.model.release();
        JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
        jPopupMenu.setPreferredSize(this.size);
        jPopupMenu.removePopupMenuListener(this);
    }
}

