/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.chooser;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import net.sf.amemailchecker.gui.component.chooser.AlignmentChooser;
import net.sf.amemailchecker.gui.component.chooser.AlignmentChooserCell;
import net.sf.amemailchecker.gui.component.chooser.AlignmentChooserModel;
import net.sf.amemailchecker.gui.component.chooser.AlignmentChooserUI;

public class BasicAlignmentChooserUI
extends AlignmentChooserUI {
    private AlignmentChooser component;
    private List<AlignmentChooserCell> cells;
    private transient AlignmentChooserCell cell = new AlignmentChooserCell();
    private MouseAdapter cellMouseListener;
    private ChangeListener modelChangeListener;
    private PropertyChangeListener propertyChangeListener;
    private Color cellSelectionColor;
    private Color cellColor;
    private Color cellDelimiterColor;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicAlignmentChooserUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.component = (AlignmentChooser)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallComponents();
    }

    public void installDefaults() {
        this.cellSelectionColor = new Color(188, 210, 230);
        this.cellColor = Color.LIGHT_GRAY;
        this.cellDelimiterColor = Color.WHITE;
    }

    public void installListeners() {
        this.cellMouseListener = new CellMouseListener();
        this.component.addMouseListener(this.cellMouseListener);
        this.modelChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BasicAlignmentChooserUI.this.component.repaint();
            }
        };
        this.component.getModel().addChangeListener(this.modelChangeListener);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("model")) {
                    BasicAlignmentChooserUI.this.component.updateUI();
                }
            }
        };
        this.component.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallListeners() {
        this.component.removeMouseListener(this.cellMouseListener);
        this.component.getModel().removeChangeListener(this.modelChangeListener);
        this.component.removePropertyChangeListener(this.propertyChangeListener);
        this.cellMouseListener = null;
        this.modelChangeListener = null;
        this.propertyChangeListener = null;
    }

    public void installComponents() {
        this.cells = new ArrayList<AlignmentChooserCell>();
        for (int i = 0; i < this.component.getModel().getVerticalCellSize(); ++i) {
            for (int j = 0; j < this.component.getModel().getHorizontalCellSize(); ++j) {
                this.cells.add(new AlignmentChooserCell(j, i));
            }
        }
    }

    public void uninstallComponents() {
        this.cells.clear();
        this.component.removeAll();
        this.cells = null;
        this.component = null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        AlignmentChooserModel alignmentChooserModel = this.component.getModel();
        boolean bl = this.component.getBorder() != null;
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        int n3 = n / alignmentChooserModel.getHorizontalCellSize();
        int n4 = n2 / alignmentChooserModel.getVerticalCellSize();
        int n5 = 0;
        if (bl) {
            Insets insets = this.component.getBorder().getBorderInsets(this.component);
            n5 = insets.top;
            n3 -= (insets.left + insets.right + alignmentChooserModel.getHorizontalCellSize()) / alignmentChooserModel.getHorizontalCellSize();
            n4 -= (insets.top + insets.bottom + alignmentChooserModel.getVerticalCellSize()) / alignmentChooserModel.getVerticalCellSize();
        }
        for (int i = 0; i < alignmentChooserModel.getVerticalCellSize(); ++i) {
            int n6;
            if (i > 0) {
                n5 += n4;
            }
            if (bl) {
                Insets insets = this.component.getBorder().getBorderInsets(this.component);
                n6 = insets.left;
            } else {
                n6 = 0;
            }
            for (int j = 0; j < alignmentChooserModel.getHorizontalCellSize(); ++j) {
                if (j > 0) {
                    n6 += n3;
                }
                int n7 = n5;
                int n8 = n6;
                int n9 = n3;
                int n10 = n4;
                if (!this.component.isFillWholeCell()) {
                    if (i != 0 && i != alignmentChooserModel.getVerticalCellSize() - 1) {
                        n7 += n4 / 4;
                    }
                    n7 = i == alignmentChooserModel.getVerticalCellSize() - 1 ? (n7 += n4 / 2) : ++n7;
                    n8 = j == alignmentChooserModel.getHorizontalCellSize() - 1 ? (n8 += n3 / 10) : ++n8;
                    if (j == alignmentChooserModel.getHorizontalCellSize() - 1 || j == 0) {
                        n9 -= n3 / 10;
                    }
                    n10 = n4 / 2;
                } else {
                    ++n7;
                    ++n8;
                    --n9;
                    --n10;
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(n8, n7, n9, n10);
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color = graphics2D.getColor();
                graphics.setColor(this.cellDelimiterColor);
                graphics.drawRect(n6, n5, n3, n4);
                graphics2D.setColor(alignmentChooserModel.isChoosenAlignment(j, i) ? this.cellSelectionColor : this.cellColor);
                graphics2D.fill(double_);
                graphics2D.setColor(color);
                this.cell.setX(j);
                this.cell.setY(i);
                AlignmentChooserCell alignmentChooserCell = this.cells.get(this.cells.indexOf(this.cell));
                alignmentChooserCell.setRectangle(double_);
            }
        }
    }

    private class CellMouseListener
    extends MouseAdapter {
        private CellMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            for (AlignmentChooserCell alignmentChooserCell : BasicAlignmentChooserUI.this.cells) {
                if (!alignmentChooserCell.getRectangle().contains(point)) continue;
                BasicAlignmentChooserUI.this.component.getModel().setAlignmentX(alignmentChooserCell.getX());
                BasicAlignmentChooserUI.this.component.getModel().setAlignmentY(alignmentChooserCell.getY());
                for (ActionListener actionListener : BasicAlignmentChooserUI.this.component.getActionListeners()) {
                    actionListener.actionPerformed(new ActionEvent(BasicAlignmentChooserUI.this.component, 1001, "", mouseEvent.getWhen(), mouseEvent.getModifiers()));
                }
            }
        }
    }
}

