/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.chooser;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.sf.amemailchecker.gui.component.chooser.AlignmentChooserModel;

public class DefaultAlignmentChooserModel
implements AlignmentChooserModel {
    private int alignmentX = -1;
    private int alignmentY = -1;
    private int horizontalCellSize = 3;
    private int verticalCellSize = 3;
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public int getAlignmentX() {
        return this.alignmentX;
    }

    @Override
    public void setAlignmentX(int n) {
        this.alignmentX = n;
        this.fireStateChanged();
    }

    @Override
    public int getAlignmentY() {
        return this.alignmentY;
    }

    @Override
    public void setAlignmentY(int n) {
        this.alignmentY = n;
        this.fireStateChanged();
    }

    @Override
    public int getHorizontalCellSize() {
        return this.horizontalCellSize;
    }

    public void setHorizontalCellSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("horizontalCellSize is invalid");
        }
        this.horizontalCellSize = n;
        this.fireStateChanged();
    }

    @Override
    public int getVerticalCellSize() {
        return this.verticalCellSize;
    }

    public void setVerticalCellSize(int n) {
        if (this.horizontalCellSize < 1) {
            throw new IllegalArgumentException("verticalCellSize is invalid");
        }
        this.verticalCellSize = n;
        this.fireStateChanged();
    }

    @Override
    public boolean isChoosenAlignment(int n, int n2) {
        return this.alignmentX == n && this.alignmentY == n2;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }
}

