/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.container;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import javax.swing.JViewport;

public class LabeledViewport
extends JViewport {
    private String label;
    private boolean drawLabel;

    public LabeledViewport() {
        this("", false);
    }

    public LabeledViewport(String string) {
        this(string, true);
    }

    public LabeledViewport(String string, boolean bl) {
        this.label = string;
        this.drawLabel = bl;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setDrawLabel(boolean bl) {
        this.drawLabel = bl;
        this.repaint();
    }

    @Override
    public void setView(Component component) {
        super.setView(component);
        component.addComponentListener(new JViewport.ViewListener(){
            private int height;

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n = LabeledViewport.this.getViewSize().height;
                if (n <= 0 && this.height != n) {
                    LabeledViewport.this.repaint();
                }
                if (n > 0 && this.height == 0) {
                    LabeledViewport.this.repaint();
                }
                this.height = n;
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.drawLabel || this.getViewSize().height > 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AttributedString attributedString = new AttributedString(this.label);
        attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        int n = graphics2D.getFontMetrics().stringWidth(this.label);
        graphics2D.drawString(attributedString.getIterator(), this.getWidth() / 2 - n / 2, 50);
    }
}

