/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.container;

import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.amemailchecker.gui.component.button.CrossHeaderButton;

public class TabHeaderPanel
extends JPanel {
    private int maxTextLength = 20;
    private boolean paintCloseButton;
    private int index;
    private JLabel textLabel;
    private CrossHeaderButton closeButton;

    public TabHeaderPanel(int n) {
        this.index = n;
    }

    public TabHeaderPanel(int n, boolean bl) {
        this(n);
        this.paintCloseButton = bl;
    }

    public void init() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.setLayout(new FlowLayout(1, 5, 0));
        this.setOpaque(false);
        this.textLabel = new JLabel();
        this.textLabel.putClientProperty("tabIndex", this.index);
        this.add(this.textLabel);
        if (this.paintCloseButton) {
            this.closeButton = new CrossHeaderButton();
            this.closeButton.putClientProperty("tabIndex", this.index);
            this.add(this.closeButton);
        }
    }

    public void setText(String string) {
        this.textLabel.setText(string.length() > this.maxTextLength ? string.substring(0, this.maxTextLength) + "... " : string);
        this.textLabel.setToolTipText(string);
    }

    public String getText() {
        return this.textLabel.getText();
    }

    public void setIndex(int n) {
        this.index = n;
        this.textLabel.putClientProperty("tabIndex", n);
        if (this.closeButton != null) {
            this.closeButton.putClientProperty("tabIndex", n);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.closeButton != null) {
            this.closeButton.addActionListener(actionListener);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.textLabel.addMouseListener(mouseListener);
    }

    public void setMaxTextLength(int n) {
        this.maxTextLength = n;
    }
}

