/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.container;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import net.sf.amemailchecker.gui.component.container.TabHeaderPanel;
import net.sf.amemailchecker.gui.component.container.TabValueWrapper;

public class TabPane<T>
extends JTabbedPane {
    protected Set<TabValueWrapper<T>> wrappers = new HashSet<TabValueWrapper<T>>();
    protected Set<TabHeaderPanel> headers = new HashSet<TabHeaderPanel>();

    public TabPane() {
        this.setTabLayoutPolicy(0);
    }

    public synchronized void addTab(String string, Component component, boolean bl) {
        super.addTab(string, component);
        int n = this.getTabCount() - 1;
        TabHeaderPanel tabHeaderPanel = new TabHeaderPanel(n, bl);
        tabHeaderPanel.init();
        tabHeaderPanel.addActionListener(new CloseTabActionListener());
        tabHeaderPanel.addMouseListener(new ChangeTranslationMouseListener());
        tabHeaderPanel.setText(string);
        this.setTabComponentAt(n, tabHeaderPanel);
        this.headers.add(tabHeaderPanel);
    }

    @Override
    public synchronized void remove(int n) {
        if (n > 0) {
            boolean bl = this.getSelectedIndex() == n;
            super.remove(n);
            Iterator<Object> iterator = this.wrappers.iterator();
            while (iterator.hasNext()) {
                TabValueWrapper<T> object2 = iterator.next();
                if (object2.getIndex() != n) continue;
                iterator.remove();
                break;
            }
            for (TabValueWrapper<T> tabValueWrapper : this.wrappers) {
                if (tabValueWrapper.getIndex() <= n) continue;
                tabValueWrapper.setIndex(tabValueWrapper.getIndex() - 1);
            }
            iterator = this.headers.iterator();
            while (iterator.hasNext()) {
                TabHeaderPanel tabHeaderPanel = (TabHeaderPanel)iterator.next();
                if (tabHeaderPanel.getIndex() != n) continue;
                iterator.remove();
                break;
            }
            for (TabHeaderPanel tabHeaderPanel : this.headers) {
                if (tabHeaderPanel.getIndex() <= n) continue;
                tabHeaderPanel.setIndex(tabHeaderPanel.getIndex() - 1);
            }
            if (bl) {
                this.setSelectedIndex(0);
            }
        }
    }

    public class ChangeTranslationMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object object = ((JComponent)mouseEvent.getComponent()).getClientProperty("tabIndex");
            if (object != null) {
                TabPane.this.setSelectedIndex((Integer)object);
            }
        }
    }

    public class CloseTabActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            Object object = abstractButton.getClientProperty("tabIndex");
            if (object != null) {
                TabPane.this.remove((Integer)object);
            }
        }
    }
}

