/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.container;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import net.sf.amemailchecker.gui.component.button.DropDownMenuListener;
import net.sf.amemailchecker.gui.component.container.TitledPanelModel;

public class TitledPanel
extends JPanel {
    private String title;
    private Border captionBorder = BorderFactory.createEtchedBorder();
    private boolean highlighted;
    private boolean drawActionStrip = true;
    private List<Action> actions = new ArrayList<Action>();
    private TitledPanelModel model = new TitledPanelModel();
    private EventListenerList actionListeners = new EventListenerList();
    private ExtMouseListener extMouseListener;

    public TitledPanel(String string) {
        this.title = string;
        this.updateListeners();
    }

    void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    boolean isHighlighted() {
        return this.highlighted;
    }

    public boolean isDrawActionStrip() {
        return this.drawActionStrip;
    }

    public void setDrawActionStrip(boolean bl) {
        this.drawActionStrip = bl;
        this.updateListeners();
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(ActionListener.class, actionListener);
    }

    public void removeActions() {
        this.actions.clear();
    }

    private void updateListeners() {
        if (!this.drawActionStrip) {
            this.removeMouseListener(this.extMouseListener);
            this.removeMouseMotionListener(this.extMouseListener);
            this.extMouseListener = null;
        } else if (this.extMouseListener == null) {
            this.extMouseListener = new ExtMouseListener(this);
            this.addMouseMotionListener(this.extMouseListener);
            this.addMouseListener(this.extMouseListener);
        }
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 30, insets.left, insets.bottom, insets.right);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = graphics2D.getFontMetrics().stringWidth(this.title);
        int n2 = (int)graphics2D.getFontMetrics().getStringBounds(this.title, graphics2D).getHeight();
        graphics2D.drawString(this.title, this.getWidth() / 2 - n / 2, 15 + n2 / 4);
        this.captionBorder.paintBorder(this, graphics2D, 0, 0, this.getWidth(), 30);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        if (this.drawActionStrip) {
            this.drawActionsStrip(graphics2D);
        }
    }

    private void drawActionsStrip(Graphics2D graphics2D) {
        graphics2D.setColor(this.getBackground().brighter());
        this.drawAngels(graphics2D, 0, 1);
        this.drawAngels(graphics2D, 7, 1);
        this.drawAngels(graphics2D, 14, 1);
        graphics2D.setColor(this.highlighted ? this.getForeground() : this.getBackground().darker().darker());
        this.drawAngels(graphics2D, 0, 0);
        this.drawAngels(graphics2D, 7, 0);
        this.drawAngels(graphics2D, 14, 0);
        graphics2D.setColor(this.getBackground().brighter());
        this.drawAngels(graphics2D, 0, -1);
        this.drawAngels(graphics2D, 7, -1);
        this.drawAngels(graphics2D, 14, -1);
        if (this.highlighted) {
            graphics2D.setColor(this.getBackground().darker().darker());
            graphics2D.drawLine(this.getWidth() - 12, 5, this.getWidth() - 12, 24);
            graphics2D.setColor(this.getBackground().brighter());
            graphics2D.drawLine(this.getWidth() - 11, 5, this.getWidth() - 11, 24);
        }
    }

    private void drawAngels(Graphics2D graphics2D, int n, int n2) {
        GeneralPath generalPath = new GeneralPath(0, 3);
        double[] dArray = new double[]{this.getWidth() - 10 - n2, this.getWidth() - 5 - n2, this.getWidth() - 10 - n2};
        double[] dArray2 = new double[]{5 + n, 7.5 + (double)n, 10 + n};
        generalPath.moveTo(dArray[0], dArray2[0]);
        for (int i = 1; i < dArray.length; ++i) {
            generalPath.lineTo(dArray[i], dArray2[i]);
        }
        graphics2D.draw(generalPath);
    }

    private class ExtMouseListener
    extends MouseAdapter {
        private TitledPanel component;

        private ExtMouseListener(TitledPanel titledPanel2) {
            this.component = titledPanel2;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!TitledPanel.this.model.isPressPerformed()) {
                if (!this.checkIsInExtendedArea(mouseEvent.getPoint())) {
                    return;
                }
                for (ActionListener actionListener : (ActionListener[])TitledPanel.this.actionListeners.getListeners(ActionListener.class)) {
                    actionListener.actionPerformed(new ActionEvent(mouseEvent.getComponent(), 1001, "", mouseEvent.getWhen(), mouseEvent.getModifiers()));
                }
                JPopupMenu jPopupMenu = new JPopupMenu();
                TitledPanel.this.model.press();
                jPopupMenu.addPopupMenuListener(new DropDownMenuListener(false, TitledPanel.this.model, (JComponent)mouseEvent.getComponent()));
                for (Action action : TitledPanel.this.actions) {
                    jPopupMenu.add(action);
                }
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getComponent().getWidth(), 0);
            } else {
                TitledPanel.this.model.release();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.component.setHighlighted(false);
            this.component.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.checkIsInExtendedArea(mouseEvent.getPoint()) && !TitledPanel.this.highlighted) {
                this.component.setHighlighted(true);
                this.component.repaint();
                return;
            }
            if (!this.checkIsInExtendedArea(mouseEvent.getPoint()) && TitledPanel.this.highlighted) {
                this.component.setHighlighted(false);
                this.component.repaint();
            }
        }

        private boolean checkIsInExtendedArea(Point point) {
            return point.getLocation().getX() > (double)(this.component.getWidth() - 10) && point.getLocation().getY() < 30.0;
        }
    }
}

