/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.list;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import net.sf.amemailchecker.gui.component.list.CheckedValueListModel;

public abstract class CheckedValueListCellRenderer
extends JPanel
implements ListCellRenderer {
    private JToggleButton component;
    private JLabel label;
    private boolean paintSeparator;

    public CheckedValueListCellRenderer(JToggleButton jToggleButton, boolean bl) {
        this.component = jToggleButton;
        this.paintSeparator = bl;
        this.init();
    }

    private void init() {
        this.setLayout(new FlowLayout(0, 5, 0));
        this.component.setOpaque(false);
        this.add(this.component);
        if (this.paintSeparator) {
            JSeparator jSeparator = new JSeparator(1);
            jSeparator.setPreferredSize(new Dimension(3, this.getPreferredSize().height / 2));
            this.add(jSeparator);
        }
        this.label = new JLabel();
        this.add(this.label);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        boolean bl3 = ((CheckedValueListModel)jList.getModel()).isElementSelected(n);
        this.label.setText(object.toString());
        this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
        if (bl3) {
            this.label.setForeground(bl ? jList.getBackground() : jList.getSelectionBackground());
        } else {
            this.label.setForeground(UIManager.getColor("Label.foreground"));
        }
        this.component.setSelected(bl3);
        return this;
    }

    protected JToggleButton getComponent() {
        return this.component;
    }

    public static class RadioListCellRenderer
    extends CheckedValueListCellRenderer {
        public RadioListCellRenderer() {
            this(false);
        }

        public RadioListCellRenderer(boolean bl) {
            super(new JRadioButton(), bl);
        }
    }

    public static class CheckBoxListCellRenderer
    extends CheckedValueListCellRenderer {
        public CheckBoxListCellRenderer() {
            this(false);
        }

        public CheckBoxListCellRenderer(boolean bl) {
            super(new JCheckBox(), bl);
        }
    }
}

