/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import net.sf.amemailchecker.gui.component.CheckedValueWrapper;
import net.sf.amemailchecker.gui.component.list.CheckedValueListModel;

public class DefaultCheckedValueListModel<T>
extends DefaultListModel
implements CheckedValueListModel<T> {
    private List<CheckedValueWrapper<T>> values = new ArrayList<CheckedValueWrapper<T>>();
    private boolean useSingleSelection;

    public DefaultCheckedValueListModel() {
    }

    public DefaultCheckedValueListModel(Collection<T> collection, T ... TArray) {
        this();
        this.addElements(collection, TArray);
    }

    @Override
    public void addElements(Collection<T> collection, T ... TArray) {
        for (T t : collection) {
            boolean bl = false;
            for (T t2 : TArray) {
                if (!t.equals(t2)) continue;
                bl = true;
                break;
            }
            this.addElement(t, bl);
        }
    }

    @Override
    public void addElement(T t, boolean bl) {
        CheckedValueWrapper<T> checkedValueWrapper = new CheckedValueWrapper<T>(t, bl);
        this.values.add(checkedValueWrapper);
        super.addElement(t);
    }

    @Override
    public T getElementAt(int n) {
        return this.values.get(n).getValue();
    }

    @Override
    public List<T> getValues() {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (CheckedValueWrapper<T> checkedValueWrapper : this.values) {
            arrayList.add(checkedValueWrapper.getValue());
        }
        return arrayList;
    }

    @Override
    public List<T> getSelectedValues() {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (CheckedValueWrapper<T> checkedValueWrapper : this.values) {
            if (!checkedValueWrapper.isSelected()) continue;
            arrayList.add(checkedValueWrapper.getValue());
        }
        return arrayList;
    }

    @Override
    public void selectElement(int n, boolean bl) {
        if (this.useSingleSelection) {
            this.deselectAll();
        }
        this.values.get(n).setSelected(bl);
        this.fireContentsChanged(this.values.get(n), n, n);
    }

    @Override
    public boolean isElementSelected(int n) {
        return this.values.get(n).isSelected();
    }

    @Override
    public boolean containsElement(T t) {
        for (CheckedValueWrapper<T> checkedValueWrapper : this.values) {
            if (!checkedValueWrapper.getValue().equals(t)) continue;
            return true;
        }
        return false;
    }

    public void deselectAll() {
        for (CheckedValueWrapper<T> checkedValueWrapper : this.values) {
            checkedValueWrapper.setSelected(false);
        }
        this.fireContentsChanged(-1, -1, -1);
    }

    @Override
    public boolean isUseSingleSelection() {
        return this.useSingleSelection;
    }

    @Override
    public void setUseSingleSelection(boolean bl) {
        this.useSingleSelection = bl;
    }

    @Override
    public void removeElementAt(int n) {
        super.removeElementAt(n);
        this.values.remove(n);
    }

    @Override
    public void deleteElement(T t) {
        int n = super.indexOf(t);
        super.removeElement(t);
        this.values.remove(n);
    }

    @Override
    public void clear() {
        super.clear();
        this.values.clear();
    }
}

