/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import net.sf.amemailchecker.gui.component.list.HistoryListModel;
import net.sf.amemailchecker.gui.component.list.HistoryListValueWrapper;

public class DefaultHistoryListModel<T>
extends DefaultListModel
implements HistoryListModel<T> {
    private TreeMap<Integer, HistoryListValueWrapper<T>> values;
    private Map<T, Boolean> originStatuses;
    private List<T> origins = new ArrayList<T>();
    private int editedCount;
    private int deletedCount;
    private int statusesCount;

    public DefaultHistoryListModel() {
        this.values = new TreeMap();
        this.originStatuses = new HashMap<T, Boolean>();
    }

    public DefaultHistoryListModel(Collection<T> collection) {
        this();
        this.origins.addAll(collection);
        this.invalidate(collection);
    }

    @Override
    public T getElementAt(int n) {
        HistoryListValueWrapper<T> historyListValueWrapper = this.getElementWrapperAt(n);
        return historyListValueWrapper != null ? (T)historyListValueWrapper.getValue() : null;
    }

    protected HistoryListValueWrapper<T> getElementWrapperAt(int n) {
        HistoryListValueWrapper<T> historyListValueWrapper = this.values.get(this.findIndex(n));
        if (historyListValueWrapper == null) {
            return null;
        }
        if (historyListValueWrapper.isDeleted()) {
            for (int i = n; i < this.values.size() && (historyListValueWrapper = this.values.get(i)).isDeleted(); ++i) {
            }
        }
        return historyListValueWrapper;
    }

    private int findIndex(int n) {
        int n2 = 0;
        for (int i = 0; i < this.values.size(); ++i) {
            HistoryListValueWrapper<T> historyListValueWrapper = this.values.get(i);
            if (historyListValueWrapper.isDeleted()) {
                ++n2;
            }
            if (i == n) break;
        }
        return n2 + n;
    }

    @Override
    public void setEditedElement(T t, int n) {
        HistoryListValueWrapper<T> historyListValueWrapper = this.getElementWrapperAt(n);
        if (historyListValueWrapper != null) {
            super.set(n, t);
            historyListValueWrapper.setValue(t);
        } else {
            n = this.insertElement(t);
            historyListValueWrapper = this.getElementWrapperAt(n);
        }
        historyListValueWrapper.setEdited(true);
        ++this.editedCount;
    }

    public int insertElement(T t) {
        return this.insertElement(t, this.originStatuses.containsKey(t) ? this.originStatuses.get(t) : true);
    }

    @Override
    public int insertElement(T t, boolean bl) {
        if (!this.origins.contains(t)) {
            this.origins.add(t);
        }
        if (!this.originStatuses.containsKey(t)) {
            this.originStatuses.put(t, bl);
        }
        int n = this.size();
        this.values.put(n, new HistoryListValueWrapper<T>(t, bl));
        super.addElement(t);
        return n;
    }

    @Override
    public void setDeletedElement(int n) {
        super.remove(n);
        HistoryListValueWrapper<T> historyListValueWrapper = this.getElementWrapperAt(n);
        historyListValueWrapper.setDeleted(true);
        historyListValueWrapper.setEdited(false);
        ++this.deletedCount;
        this.editedCount = this.decreaseCount(this.editedCount);
    }

    @Override
    public boolean isActive(int n) {
        return this.getElementWrapperAt(n).isSelected();
    }

    @Override
    public void setActive(int n) {
        HistoryListValueWrapper<T> historyListValueWrapper;
        historyListValueWrapper.setSelected(!(historyListValueWrapper = this.getElementWrapperAt(n)).isSelected());
        ++this.statusesCount;
        this.fireContentsChanged(this, n, n);
    }

    @Override
    public void invalidate() {
        this.invalidate(this.origins);
    }

    @Override
    public void invalidate(Collection<T> collection) {
        this.clear();
        for (T t : collection) {
            this.insertElement(t);
        }
    }

    @Override
    public void invalidate(int n) {
        HistoryListValueWrapper<T> historyListValueWrapper = this.getElementWrapperAt(n);
        historyListValueWrapper.setValue(this.origins.get(n));
        historyListValueWrapper.setEdited(false);
        historyListValueWrapper.setDeleted(false);
        historyListValueWrapper.setSelected(historyListValueWrapper.getStatusOrigin());
        this.editedCount = this.decreaseCount(this.editedCount);
        this.deletedCount = this.decreaseCount(this.deletedCount);
        this.statusesCount = this.decreaseCount(this.statusesCount);
    }

    @Override
    public void clear() {
        super.clear();
        this.values.clear();
        this.editedCount = 0;
        this.statusesCount = 0;
        this.deletedCount = 0;
    }

    @Override
    public void clearOrigins() {
        this.clear();
        this.originStatuses.clear();
        this.origins.clear();
    }

    private int decreaseCount(int n) {
        if (n == 0) {
            return n;
        }
        return --n;
    }

    @Override
    public boolean isChanged() {
        return this.editedCount > 0 || this.deletedCount > 0 || this.statusesCount > 0;
    }

    @Override
    public boolean isChanged(int n) {
        HistoryListValueWrapper<T> historyListValueWrapper = this.values.get(n);
        return historyListValueWrapper.isEdited() || historyListValueWrapper.isDeleted() || historyListValueWrapper.isStatusChanged();
    }

    @Override
    public Collection<T> getEdited() {
        ArrayList arrayList = new ArrayList();
        for (HistoryListValueWrapper<T> historyListValueWrapper : this.values.values()) {
            if (!historyListValueWrapper.isEdited()) continue;
            arrayList.add(historyListValueWrapper.getValue());
        }
        return arrayList;
    }

    @Override
    public Collection<T> getDeleted() {
        ArrayList arrayList = new ArrayList();
        for (HistoryListValueWrapper<T> historyListValueWrapper : this.values.values()) {
            if (!historyListValueWrapper.isDeleted()) continue;
            arrayList.add(historyListValueWrapper.getValue());
        }
        return arrayList;
    }

    @Override
    public Map<T, Boolean> getStatuses(boolean bl) {
        HashMap hashMap = new HashMap();
        for (HistoryListValueWrapper<T> historyListValueWrapper : this.values.values()) {
            if (!historyListValueWrapper.isStatusChanged()) continue;
            hashMap.put(historyListValueWrapper.getValue(), historyListValueWrapper.isSelected());
            if (!bl) continue;
            historyListValueWrapper.setStatusOrigin(historyListValueWrapper.isSelected());
        }
        return hashMap;
    }

    @Override
    public Collection<T> getOrigins() {
        return this.origins;
    }
}

