/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import net.sf.amemailchecker.gui.component.table.CheckedValueTableWrapper;
import net.sf.amemailchecker.gui.component.table.RowComparator;

public abstract class CheckedValueTableModel<T>
extends DefaultTableModel {
    private List<CheckedValueTableWrapper<T>> rowValues = new ArrayList<CheckedValueTableWrapper<T>>();
    private boolean[] sortOrder = new boolean[0];
    private Map<Integer, RowComparator<T>> comparators = new HashMap<Integer, RowComparator<T>>();

    public void addColumn(Object object, Vector vector) {
        super.addColumn(object, vector);
        boolean[] blArray = new boolean[this.sortOrder.length + 1];
        System.arraycopy(this.sortOrder, 0, blArray, 0, this.sortOrder.length);
        this.sortOrder = blArray;
    }

    public void setDataVector(Vector vector, Vector vector2) {
        super.setDataVector(vector, vector2);
        this.sortOrder = new boolean[vector2.size()];
    }

    public void insert(T ... TArray) {
        if (TArray == null) {
            return;
        }
        for (T t : TArray) {
            CheckedValueTableWrapper<T> checkedValueTableWrapper = new CheckedValueTableWrapper<T>(t, false);
            checkedValueTableWrapper.setRowNum(super.getRowCount());
            this.rowValues.add(checkedValueTableWrapper);
            Object[] objectArray = new Object[this.getColumnCount()];
            objectArray[0] = checkedValueTableWrapper.isSelected();
            this.propagateToRow(objectArray, t);
            this.addRow(objectArray);
        }
        this.fireTableDataChanged();
    }

    protected abstract void propagateToRow(Object[] var1, T var2);

    public T getSingleSelected(int n) {
        return this.rowValues.get(n).getValue();
    }

    public List<T> getMultipleSelection(int[] nArray, boolean bl) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.rowValues.get(nArray[i]).getValue());
        }
        if (bl) {
            this.removeRowValue(nArray);
        }
        return arrayList;
    }

    public List<T> values() {
        ArrayList arrayList = new ArrayList();
        for (CheckedValueTableWrapper<T> checkedValueTableWrapper : this.rowValues) {
            arrayList.add(checkedValueTableWrapper.getValue());
        }
        return arrayList;
    }

    public int getSingleSelectedIndex(T t) {
        for (CheckedValueTableWrapper<T> checkedValueTableWrapper : this.rowValues) {
            if (!checkedValueTableWrapper.getValue().equals(t)) continue;
            return checkedValueTableWrapper.getRowNum();
        }
        return -1;
    }

    public List<T> getChecked(boolean bl) {
        ArrayList arrayList = new ArrayList();
        for (CheckedValueTableWrapper<T> checkedValueTableWrapper : this.rowValues) {
            if (!checkedValueTableWrapper.isSelected()) continue;
            arrayList.add(checkedValueTableWrapper.getValue());
        }
        if (bl) {
            this.removeSelected();
        }
        return arrayList;
    }

    public void clear() {
        Iterator<CheckedValueTableWrapper<T>> iterator = this.rowValues.iterator();
        while (iterator.hasNext()) {
            this.removeRowValue(iterator.next(), iterator);
        }
    }

    public void removeRowValue(int[] nArray) {
        for (int n : nArray) {
            this.removeRowValue(n);
            this.fireRowValueDeleted(n);
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = nArray[i] - 1;
            }
        }
    }

    public void removeRowValue(int n) {
        this.rowValues.remove(n);
        this.removeRow(n);
        this.fireRowValueDeleted(n);
    }

    public void removeRowValue(CheckedValueTableWrapper<T> checkedValueTableWrapper, Iterator iterator) {
        int n = checkedValueTableWrapper.getRowNum();
        this.removeRow(n);
        iterator.remove();
        this.fireRowValueDeleted(n);
    }

    public void removeSelected() {
        Iterator<CheckedValueTableWrapper<T>> iterator = this.rowValues.iterator();
        while (iterator.hasNext()) {
            CheckedValueTableWrapper<T> checkedValueTableWrapper = iterator.next();
            if (!checkedValueTableWrapper.isSelected()) continue;
            this.removeRowValue(checkedValueTableWrapper, iterator);
        }
    }

    public void remove(T t) {
        this.removeRowValue(this.getSingleSelectedIndex(t));
    }

    private void fireRowValueDeleted(int n) {
        for (CheckedValueTableWrapper<T> checkedValueTableWrapper : this.rowValues) {
            if (checkedValueTableWrapper.getRowNum() <= n) continue;
            checkedValueTableWrapper.setRowNum(checkedValueTableWrapper.getRowNum() - 1);
        }
    }

    public void clearSelection() {
        for (CheckedValueTableWrapper<T> checkedValueTableWrapper : this.rowValues) {
            checkedValueTableWrapper.setSelected(false);
            this.fireTableCellUpdated(checkedValueTableWrapper.getRowNum(), 0);
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        CheckedValueTableWrapper<T> checkedValueTableWrapper = this.rowValues.get(n);
        if (n2 == 0) {
            return checkedValueTableWrapper.isSelected();
        }
        return this.getValueAt(checkedValueTableWrapper.getValue(), n2);
    }

    protected abstract Object getValueAt(T var1, int var2);

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            this.rowValues.get(n).setSelected((Boolean)object);
        } else {
            super.setValueAt(object, n, n2);
        }
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    public void sort(int n, boolean bl) {
        this.sort(n, this.comparators.get(n), bl);
    }

    public void sort(int n, RowComparator<T> rowComparator, boolean bl) {
        this.sortOrder[n] = bl;
        rowComparator.setOrdering(this.sortOrder[n]);
        Collections.sort(this.rowValues, rowComparator);
        for (int i = 0; i < this.rowValues.size(); ++i) {
            this.rowValues.get(i).setRowNum(i);
        }
        this.fireTableRowsUpdated(0, this.rowValues.size() - 1);
    }

    public boolean getSortOrder(int n) {
        return this.sortOrder[n];
    }

    public void assignComparator(int n, RowComparator<T> rowComparator) {
        this.comparators.put(n, rowComparator);
    }
}

