/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.table;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import net.sf.amemailchecker.gui.component.table.CheckedValueTableModel;

public class SelectionHeaderCellRenderer
extends DefaultTableCellRenderer {
    private MouseListener mouseListener = new MessageSelectionMouseListener();
    private int columnIndex;
    private JCheckBox rendererComponent = new JCheckBox();
    private CheckedValueTableModel model;

    public SelectionHeaderCellRenderer() {
        this(0);
    }

    public SelectionHeaderCellRenderer(int n) {
        this.columnIndex = n;
        this.addItemListener(new DefaultSelectionItemListener());
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this.model == null) {
            this.model = (CheckedValueTableModel)jTable.getModel();
        }
        if (this.columnIndex != n2) {
            return this.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        JTableHeader jTableHeader = jTable.getTableHeader();
        jTableHeader.addMouseListener(this.mouseListener);
        this.rendererComponent.setForeground(jTableHeader.getForeground());
        this.rendererComponent.setBackground(jTableHeader.getBackground());
        this.rendererComponent.setFont(jTableHeader.getFont());
        this.rendererComponent.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.rendererComponent.setHorizontalAlignment(0);
        this.rendererComponent.setAlignmentX(0.5f);
        return this.rendererComponent;
    }

    public void addItemListener(ItemListener itemListener) {
        this.rendererComponent.addItemListener(itemListener);
    }

    private class DefaultSelectionItemListener
    implements ItemListener {
        private DefaultSelectionItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = itemEvent.getStateChange() == 1;
            for (int i = 0; i < SelectionHeaderCellRenderer.this.model.getRowCount(); ++i) {
                SelectionHeaderCellRenderer.this.model.setValueAt(bl, i, 0);
            }
        }
    }

    private class MessageSelectionMouseListener
    extends MouseAdapter {
        private boolean mousePressed;

        private MessageSelectionMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1) {
                return;
            }
            if (mouseEvent.getClickCount() > 1) {
                return;
            }
            if (this.mousePressed) {
                TableColumnModel tableColumnModel;
                int n;
                this.mousePressed = false;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                JTable jTable = jTableHeader.getTable();
                int n2 = jTable.convertColumnIndexToModel(n = (tableColumnModel = jTable.getColumnModel()).getColumnIndexAtX(mouseEvent.getX()));
                if (n2 == SelectionHeaderCellRenderer.this.columnIndex) {
                    SelectionHeaderCellRenderer.this.rendererComponent.doClick();
                }
            }
            ((JTableHeader)mouseEvent.getSource()).repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.mousePressed = true;
        }
    }
}

