/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.component.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import net.sf.amemailchecker.gui.component.CheckedValueWrapper;
import net.sf.amemailchecker.gui.component.tree.CheckedValueTreeModel;
import net.sf.amemailchecker.gui.component.tree.DefaultTreeModelHierarchyIterator;
import net.sf.amemailchecker.gui.component.tree.TreeModelFilter;
import net.sf.amemailchecker.gui.component.tree.TreeModelHierarchyIterator;

public class DefaultCheckedValueTreeModel<T>
extends DefaultTreeModel
implements CheckedValueTreeModel<T> {
    private TreeModelHierarchyIterator<T> iterator;
    private List<MutableTreeNode> nodes = new ArrayList<MutableTreeNode>();
    private List<CheckedValueWrapper<MutableTreeNode>> wrappers = new ArrayList<CheckedValueWrapper<MutableTreeNode>>();
    private List<TreeModelFilter<T>> filters = new ArrayList<TreeModelFilter<T>>();

    @Override
    public void addFilter(TreeModelFilter<T> treeModelFilter) {
        this.filters.add(treeModelFilter);
    }

    public DefaultCheckedValueTreeModel() {
        super(new DefaultMutableTreeNode("/"));
        this.wrappers.add(new CheckedValueWrapper<MutableTreeNode>((MutableTreeNode)this.getRoot(), false));
    }

    public DefaultCheckedValueTreeModel(Collection<T> collection) {
        this();
        this.insert(new DefaultTreeModelHierarchyIterator<Object>(collection.toArray()));
    }

    public DefaultCheckedValueTreeModel(TreeModelHierarchyIterator<T> treeModelHierarchyIterator) {
        this();
        this.insert(treeModelHierarchyIterator);
    }

    @Override
    public void insert(TreeModelHierarchyIterator<T> treeModelHierarchyIterator) {
        this.iterator = treeModelHierarchyIterator;
        while (treeModelHierarchyIterator.hasNext()) {
            this.insert(treeModelHierarchyIterator.parent(), treeModelHierarchyIterator.next(), treeModelHierarchyIterator.selected());
        }
    }

    @Override
    public void insert(Collection<T> collection) {
        if (this.root.getChildCount() > 0) {
            ((DefaultMutableTreeNode)this.root).removeAllChildren();
            this.reload(this.root);
        }
        this.insertChildren((MutableTreeNode)this.getRoot(), collection, false);
        this.reload(this.root);
    }

    @Override
    public void insert(T t) {
        this.insert((T)((MutableTreeNode)this.getRoot()), t, false);
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, T t, boolean bl) {
        if (this.contains(t)) {
            return;
        }
        for (TreeModelFilter<T> treeModelFilter : this.filters) {
            if (treeModelFilter.isVisible(t)) continue;
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(t);
        this.nodes.add(defaultMutableTreeNode);
        if (mutableTreeNode == null) {
            mutableTreeNode = (MutableTreeNode)this.root;
        }
        super.insertNodeInto(defaultMutableTreeNode, mutableTreeNode, mutableTreeNode.getChildCount());
        this.wrappers.add(new CheckedValueWrapper<Object>(defaultMutableTreeNode, bl));
        super.nodeStructureChanged(this.root);
    }

    @Override
    public void insert(T t, Collection<T> collection) {
        this.insertChildren(this.find(t), collection, false);
    }

    @Override
    public synchronized void insert(T t, T t2, boolean bl) {
        this.insert((T)this.find(t), t2, bl);
    }

    @Override
    public T delete(T t) {
        Object object = null;
        Iterator<MutableTreeNode> iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Object object2;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)iterator.next();
            if (!t.equals(defaultMutableTreeNode.getUserObject())) continue;
            CheckedValueWrapper<MutableTreeNode> checkedValueWrapper = this.find(((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getPath());
            if (checkedValueWrapper != null && !(object2 = (DefaultMutableTreeNode)checkedValueWrapper.getValue()).equals(this.root)) {
                object = ((DefaultMutableTreeNode)object2).getUserObject();
            }
            super.removeNodeFromParent(defaultMutableTreeNode);
            object2 = this.wrappers.iterator();
            while (object2.hasNext()) {
                CheckedValueWrapper checkedValueWrapper2 = (CheckedValueWrapper)object2.next();
                if (!((MutableTreeNode)checkedValueWrapper2.getValue()).equals(defaultMutableTreeNode)) continue;
                object2.remove();
                break;
            }
            iterator.remove();
            break;
        }
        return (T)object;
    }

    @Override
    public void select(TreePath treePath, boolean bl) {
        if (treePath == null) {
            return;
        }
        this.select(treePath.getPath(), bl);
    }

    @Override
    public void select(Object[] objectArray, boolean bl) {
        CheckedValueWrapper<MutableTreeNode> checkedValueWrapper = this.find(objectArray);
        if (checkedValueWrapper == null) {
            return;
        }
        MutableTreeNode mutableTreeNode = checkedValueWrapper.getValue();
        checkedValueWrapper.setSelected(bl);
        super.nodeChanged(mutableTreeNode);
        for (int i = 0; i < mutableTreeNode.getChildCount(); ++i) {
            this.select(this.getPathToRoot(mutableTreeNode.getChildAt(i)), checkedValueWrapper.isSelected());
        }
    }

    @Override
    public void select(T t, boolean bl) {
        MutableTreeNode mutableTreeNode = this.find(t);
        this.select(((DefaultMutableTreeNode)mutableTreeNode).getPath(), bl);
    }

    @Override
    public boolean isElementSelected(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        CheckedValueWrapper<MutableTreeNode> checkedValueWrapper = this.find(treePath.getPath());
        return checkedValueWrapper != null && checkedValueWrapper.isSelected();
    }

    @Override
    public boolean isElementSelected(T t) {
        for (CheckedValueWrapper<MutableTreeNode> checkedValueWrapper : this.wrappers) {
            if (!((DefaultMutableTreeNode)checkedValueWrapper.getValue()).getUserObject().equals(t)) continue;
            return checkedValueWrapper.isSelected();
        }
        return false;
    }

    @Override
    public Collection<T> getSelectedElements() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (CheckedValueWrapper<MutableTreeNode> checkedValueWrapper : this.wrappers) {
            if (checkedValueWrapper.getValue().equals(this.root) || !checkedValueWrapper.isSelected()) continue;
            arrayList.add(((DefaultMutableTreeNode)checkedValueWrapper.getValue()).getUserObject());
        }
        return arrayList;
    }

    @Override
    public Collection<T> getElements() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (CheckedValueWrapper<MutableTreeNode> checkedValueWrapper : this.wrappers) {
            if (checkedValueWrapper.getValue().equals(this.root)) continue;
            arrayList.add(((DefaultMutableTreeNode)checkedValueWrapper.getValue()).getUserObject());
        }
        return arrayList;
    }

    @Override
    public boolean contains(T t) {
        for (MutableTreeNode mutableTreeNode : this.nodes) {
            if (!((DefaultMutableTreeNode)mutableTreeNode).getUserObject().equals(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.root.getChildCount() <= 0;
    }

    @Override
    public T valueByPath(TreePath treePath) {
        if (treePath == null || treePath.getPath().length == 0) {
            return null;
        }
        CheckedValueWrapper<MutableTreeNode> checkedValueWrapper = this.find(treePath.getPath());
        if (checkedValueWrapper == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)checkedValueWrapper.getValue();
        return (T)(defaultMutableTreeNode.equals(this.root) ? null : defaultMutableTreeNode.getUserObject());
    }

    @Override
    public TreePath pathByValue(T t) {
        return new TreePath(((DefaultMutableTreeNode)this.find(t)).getPath());
    }

    @Override
    public void clear() {
        Iterator<CheckedValueWrapper<MutableTreeNode>> iterator = this.wrappers.iterator();
        while (iterator.hasNext()) {
            MutableTreeNode mutableTreeNode = iterator.next().getValue();
            if (mutableTreeNode.equals(this.root)) continue;
            super.removeNodeFromParent(mutableTreeNode);
            iterator.remove();
        }
        this.nodes.clear();
    }

    @Override
    public synchronized TreeModelHierarchyIterator<T> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    private void insertChildren(MutableTreeNode mutableTreeNode, Collection<T> collection, boolean bl) {
        for (T t : collection) {
            this.insert((T)mutableTreeNode, t, bl);
        }
    }

    private CheckedValueWrapper<MutableTreeNode> find(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        MutableTreeNode mutableTreeNode = (MutableTreeNode)objectArray[objectArray.length - 1];
        for (CheckedValueWrapper<MutableTreeNode> checkedValueWrapper : this.wrappers) {
            if (!checkedValueWrapper.getValue().equals(mutableTreeNode)) continue;
            return checkedValueWrapper;
        }
        return null;
    }

    private MutableTreeNode find(T t) {
        MutableTreeNode mutableTreeNode = null;
        for (MutableTreeNode mutableTreeNode2 : this.nodes) {
            if (!((DefaultMutableTreeNode)mutableTreeNode2).getUserObject().equals(t)) continue;
            mutableTreeNode = mutableTreeNode2;
            break;
        }
        if (mutableTreeNode == null) {
            mutableTreeNode = (MutableTreeNode)this.getRoot();
        }
        return mutableTreeNode;
    }
}

