/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.splash;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class SimpleSplashWindow
extends JWindow {
    protected Image image;
    protected JPanel imagePane;
    protected JProgressBar progress;
    protected boolean paintProgress;

    public SimpleSplashWindow() {
        this((Image)null);
    }

    public SimpleSplashWindow(Image image) {
        this(image, false);
    }

    public SimpleSplashWindow(Image image, boolean bl) {
        this.image = image;
        this.paintProgress = bl;
        this.init();
    }

    protected void init() {
        this.imagePane = new ContentPane();
        if (this.paintProgress) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(this.imagePane);
            this.progress = new JProgressBar();
            this.progress.setIndeterminate(true);
            jPanel.add(this.progress);
            this.setContentPane(jPanel);
        } else {
            this.setContentPane(this.imagePane);
        }
        this.getRootPane().setOpaque(false);
        if (this.image != null) {
            this.updateImage(this.image);
        }
    }

    public void updateImage(Image image) {
        this.image = image;
        BufferedImage bufferedImage = (BufferedImage)image;
        this.setSize(bufferedImage.getWidth(), bufferedImage.getHeight());
        if (this.paintProgress) {
            this.setSize(this.getSize().width, this.getSize().height + 5);
            this.progress.setPreferredSize(new Dimension(bufferedImage.getWidth(), 5));
        }
        this.repaint();
    }

    public void setLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        super.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
    }

    private class ContentPane
    extends JPanel {
        private ContentPane() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Rectangle rectangle = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            BufferedImage bufferedImage = (BufferedImage)SimpleSplashWindow.this.image;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics2D.setComposite(AlphaComposite.SrcOver);
            Color color = new Color(Color.LIGHT_GRAY.getRed() + 40, Color.LIGHT_GRAY.getGreen() + 40, Color.LIGHT_GRAY.getBlue() + 40);
            Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
            Point2D.Float float_2 = new Point2D.Float(0.0f, this.getHeight());
            float[] fArray = new float[]{0.0f, 0.5f, 1.0f};
            Color[] colorArray = new Color[]{Color.LIGHT_GRAY, color, Color.LIGHT_GRAY};
            graphics2D.setPaint(new LinearGradientPaint(float_, float_2, fArray, colorArray));
            graphics2D.fill(rectangle);
            graphics2D.drawImage((Image)bufferedImage, this.getX(), this.getY(), this);
            graphics2D.dispose();
        }
    }
}

