/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class SpinWidget
extends JPanel {
    public static final int DEFAULT_SPIN_HEIGHT = 12;
    public static final int DEFAULT_SPIN_WIDTH = 12;
    public static final Color DEFAULT_SPIN_COLOR = Color.BLUE;
    private int spinHeight;
    private int spinWidth;
    private boolean expanded = false;
    private Dimension size;
    private Polygon openTriangle;
    private Polygon closedTriangle;
    private Color spinColor;
    private Color spinLineColor;

    public SpinWidget() {
        this(12, 12);
    }

    public SpinWidget(int n, int n2) {
        this(n, n2, DEFAULT_SPIN_COLOR, DEFAULT_SPIN_COLOR);
    }

    public SpinWidget(int n, int n2, Color color, Color color2) {
        this.spinHeight = n;
        this.spinWidth = n2;
        this.spinColor = color;
        this.spinLineColor = color2;
        this.init();
    }

    protected void init() {
        this.size = new Dimension(this.spinWidth, this.spinHeight);
        this.openTriangle = new Polygon(new int[]{1, this.spinWidth / 2, this.spinWidth - 1}, new int[]{this.spinHeight / 2, this.spinHeight - 1, this.spinHeight / 2}, 3);
        this.closedTriangle = new Polygon(new int[]{1, 1, this.spinWidth / 2}, new int[]{1, this.spinHeight - 1, this.spinHeight / 2}, 3);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SpinWidget.this.setExpanded(!SpinWidget.this.expanded);
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(this.spinLineColor);
        graphics.drawLine(20, this.spinHeight / 2, this.getWidth() - 10, this.spinHeight / 2);
        graphics.setColor(this.spinColor);
        if (this.isExpanded()) {
            graphics.fillPolygon(this.openTriangle);
        } else {
            graphics.fillPolygon(this.closedTriangle);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    public Color getSpinColor() {
        return this.spinColor;
    }

    public void setSpinColor(Color color) {
        this.spinColor = color;
    }

    public Color getSpinLineColor() {
        return this.spinLineColor;
    }

    public void setSpinLineColor(Color color) {
        this.spinLineColor = color;
    }
}

